/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.util.Iterator;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.filter.NodeFilter;
import org.semanticweb.yars.stats.Analyser;
import org.semanticweb.yars.stats.InputAnalyser;

public abstract class DefaultAnalyser
implements Analyser {
    private final Analyser _in;
    private final int[] _element;
    private final NodeFilter[] _key;

    public DefaultAnalyser(Iterator<Node[]> iterator) {
        this(iterator, null);
    }

    public DefaultAnalyser(Iterator<Node[]> iterator, NodeFilter[] nodeFilterArray) {
        this._in = iterator instanceof Analyser ? (Analyser)iterator : new InputAnalyser(iterator);
        this._key = nodeFilterArray;
        this._element = null;
    }

    public DefaultAnalyser(Analyser analyser) {
        this(analyser, null, null);
    }

    public DefaultAnalyser(Analyser analyser, NodeFilter[] nodeFilterArray) {
        this(analyser, nodeFilterArray, null);
    }

    public DefaultAnalyser(Analyser analyser, int[] nArray) {
        this(analyser, null, nArray);
    }

    public DefaultAnalyser(Analyser analyser, NodeFilter[] nodeFilterArray, int[] nArray) {
        this._in = analyser;
        this._key = nodeFilterArray;
        this._element = nArray;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    @Override
    public Node[] next() {
        Node[] nodeArray = (Node[])this._in.next();
        Node[] nodeArray2 = this.createIn(nodeArray);
        if (this.checkKey(nodeArray2)) {
            this.analyse(nodeArray2);
        }
        return nodeArray;
    }

    private boolean checkKey(Node[] nodeArray) {
        if (this._key == null) {
            return true;
        }
        for (int i = 0; i < this._key.length; ++i) {
            NodeFilter nodeFilter = this._key[i];
            if (nodeFilter == null || nodeFilter.check(nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    private Node[] createIn(Node[] nodeArray) {
        if (this._element == null) {
            return nodeArray;
        }
        Node[] nodeArray2 = new Node[this._element.length];
        int n = 0;
        for (int n2 : this._element) {
            nodeArray2[n] = nodeArray[n2];
            ++n;
        }
        return nodeArray2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

