/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Count<T>
extends HashMap<T, Integer> {
    private static final long serialVersionUID = -8495375842744348018L;
    long _total = 0L;

    public long getTotal() {
        return this._total;
    }

    public int add(T t, int n) {
        Integer n2 = (Integer)this.get(t);
        if (n2 == null) {
            n2 = 0;
        }
        n2 = n2 + n;
        this._total += (long)n;
        this.put(t, n2);
        return n2;
    }

    public int add(T t) {
        Integer n = (Integer)this.get(t);
        if (n == null) {
            n = 0;
        }
        Integer n2 = n;
        Integer n3 = n = Integer.valueOf(n + 1);
        ++this._total;
        this.put(t, n);
        return n;
    }

    public void addAll(Map<T, Integer> map) {
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void printStats() {
        this.printStats(System.out);
    }

    public void printStats(PrintStream printStream) {
        for (Map.Entry entry : this.entrySet()) {
            printStream.println(entry.getKey() + "\t" + entry.getValue());
        }
        printStream.flush();
    }

    public void printStats(Logger logger, Level level) {
        for (Map.Entry entry : this.entrySet()) {
            logger.log(level, entry.getKey() + "\t" + entry.getValue());
        }
    }

    public void printOrderedStats() {
        this.printOrderedStats(Integer.MAX_VALUE, System.out);
    }

    public void printOrderedStats(PrintStream printStream) {
        this.printOrderedStats(Integer.MAX_VALUE, printStream);
    }

    public TreeSet<Map.Entry<T, Integer>> getKeyOrderedEntries() {
        Iterator iterator = this.entrySet().iterator();
        TreeSet<Map.Entry<T, Integer>> treeSet = new TreeSet<Map.Entry<T, Integer>>(new KeyComparator());
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        return treeSet;
    }

    public TreeSet<Map.Entry<T, Integer>> getOccurrenceOrderedEntries() {
        return this.getOccurrenceOrderedEntries(false);
    }

    public TreeSet<Map.Entry<T, Integer>> getOccurrenceOrderedEntries(boolean bl) {
        Iterator iterator = this.entrySet().iterator();
        TreeSet<Map.Entry<T, Integer>> treeSet = new TreeSet<Map.Entry<T, Integer>>(new OccurrenceComparator(bl));
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        return treeSet;
    }

    public void printOrderedStats(int n) {
        this.printOrderedStats(n, System.out);
    }

    public void printOrderedStats(int n, PrintStream printStream) {
        Iterator<Map.Entry<T, Integer>> iterator = this.getOccurrenceOrderedEntries().iterator();
        for (int i = 0; iterator.hasNext() && i < n; ++i) {
            Map.Entry<T, Integer> entry = iterator.next();
            printStream.println(entry.getKey() + "\t" + entry.getValue());
        }
        printStream.flush();
    }

    public void printOrderedStats(Logger logger, Level level) {
        this.printOrderedStats(Integer.MAX_VALUE, logger, level);
    }

    public void printOrderedStats(int n, Logger logger, Level level) {
        Iterator<Map.Entry<T, Integer>> iterator = this.getOccurrenceOrderedEntries().iterator();
        for (int i = 0; iterator.hasNext() && i < n; ++i) {
            Map.Entry<T, Integer> entry = iterator.next();
            logger.log(level, entry.getKey() + "\t" + entry.getValue());
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : this.entrySet()) {
            stringBuffer.append(entry.getKey() + "\t" + entry.getValue() + "\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this._total = 0L;
    }

    public static class KeyComparator<T extends Comparable<? super T>>
    implements Comparator<Map.Entry<T, Integer>>,
    Serializable {
        private static final long serialVersionUID = -1229701058223158391L;

        @Override
        public int compare(Map.Entry<T, Integer> entry, Map.Entry<T, Integer> entry2) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)entry.getKey();
            int n = comparable2.compareTo(comparable = (Comparable)entry2.getKey());
            if (n != 0) {
                return n;
            }
            int n2 = entry.getValue();
            int n3 = entry2.getValue();
            return n3 - n2;
        }
    }

    public static class OccurrenceComparator<T extends Comparable<? super T>>
    implements Comparator<Map.Entry<T, Integer>>,
    Serializable {
        private static final long serialVersionUID = -8794378599730605754L;
        boolean _ascending;

        public OccurrenceComparator() {
            this(false);
        }

        public OccurrenceComparator(boolean bl) {
            this._ascending = bl;
        }

        @Override
        public int compare(Map.Entry<T, Integer> entry, Map.Entry<T, Integer> entry2) {
            int n = entry.getValue();
            int n2 = entry2.getValue();
            int n3 = this._ascending ? n - n2 : n2 - n;
            if (n3 != 0) {
                return n3;
            }
            Comparable comparable = (Comparable)entry.getKey();
            Comparable comparable2 = (Comparable)entry2.getKey();
            return comparable.compareTo(comparable2);
        }
    }
}

