/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.util;

public class NxUtil {
    private NxUtil() {
    }

    public static String escapeForNx(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            if (!Character.isSupplementaryCodePoint(n)) {
                char c = (char)n;
                switch (c) {
                    case '\\': {
                        stringBuffer.append("\\\\");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("\\\"");
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        break;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        break;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        break;
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\uffff') {
                            stringBuffer.append("\\u");
                            stringBuffer.append(NxUtil.toHexString(c, 4));
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append("\\U");
            stringBuffer.append(NxUtil.toHexString(n, 8));
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String escapeForMarkup(String string) {
        String string2 = NxUtil.unescape(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string2.length(); ++i) {
            int n = string2.codePointAt(i);
            if (!Character.isSupplementaryCodePoint(n)) {
                char c = (char)n;
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&#039;");
                        break;
                    }
                    case '\\': {
                        stringBuffer.append("&#092;");
                        break;
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\uffff') {
                            stringBuffer.append("&#x");
                            stringBuffer.append(NxUtil.toHexString(c, 4));
                            stringBuffer.append(";");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append("&#x");
            stringBuffer.append(NxUtil.toHexString(n, 8));
            stringBuffer.append(";");
            ++i;
        }
        return stringBuffer.toString();
    }

    private static String toHexString(int n, int n2) {
        return String.format("%0" + n2 + "X", n);
    }

    public static String unescape(String string) {
        return NxUtil.unescape(string, false);
    }

    public static String unescape(String string, boolean bl) {
        if (bl) {
            string = NxUtil.cleanSlashes(string);
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer(6);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl3 && stringBuffer2.length() < 4) {
                stringBuffer2.append(c);
                if (stringBuffer2.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer2.toString(), 16);
                    stringBuffer.append((char)n2);
                    stringBuffer2 = new StringBuffer(4);
                    bl3 = false;
                    bl4 = false;
                    bl2 = false;
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append(stringBuffer2.toString());
                }
                continue;
            }
            if (bl4 && stringBuffer2.length() < 8) {
                stringBuffer2.append(c);
                if (stringBuffer2.length() != 8) continue;
                try {
                    stringBuffer.appendCodePoint(Integer.parseInt(stringBuffer2.toString(), 16));
                    stringBuffer2 = new StringBuffer(8);
                    bl3 = false;
                    bl4 = false;
                    bl2 = false;
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append(stringBuffer2.toString());
                }
                continue;
            }
            if (bl2) {
                bl2 = false;
                switch (c) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case '\'': {
                        stringBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        break;
                    }
                    case 'u': {
                        bl3 = true;
                        break;
                    }
                    case 'U': {
                        bl4 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl2 = true;
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl2) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    private static String cleanSlashes(String string) {
        while (string.indexOf("\\\\") != -1) {
            string = string.replaceAll("\\\\\\\\", "\\\\");
        }
        return string;
    }
}

