/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.sort;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.mem.LowMemorySniffer;
import org.semanticweb.yars.nx.mem.MemoryManager;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.sort.MergeSortIterator;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;
import org.semanticweb.yars.util.FlyweightNodeIterator;
import org.semanticweb.yars.util.SniffIterator;

public class SortIterator
implements Iterator<Node[]> {
    public static final String PREFIX = "batch";
    public static final String SUFFIX = ".nq.gz";
    private static final int INTERNAL_BATCH = 5000;
    private static final double KILL_SLOW_RATIO = 4.0;
    private static final int IN_A_ROW = 3;
    static transient Logger _log = Logger.getLogger(SortIterator.class.getName());
    private MergeSortIterator _merge = null;
    private Iterator<Node[]> _single = null;
    private int _dupes;
    private int _count = 0;

    public SortIterator(Iterator<Node[]> iterator) throws IOException, ParseException {
        this(new SortArgs(iterator));
    }

    public SortIterator(Iterator<Node[]> iterator, short s) throws IOException, ParseException {
        this(new SortArgs(iterator, s));
    }

    public SortIterator(SortArgs sortArgs) throws IOException, ParseException {
        this.sort(sortArgs);
    }

    private void sort(SortArgs sortArgs) throws IOException, ParseException {
        int n;
        Iterator[] iteratorArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        LowMemorySniffer lowMemorySniffer = null;
        if (sortArgs._linesPerBatch == Integer.MIN_VALUE) {
            lowMemorySniffer = new LowMemorySniffer();
        }
        if (lowMemorySniffer == null) {
            _log.info("Using batches with " + sortArgs._linesPerBatch + " statements each.");
        } else {
            _log.info("Using adaptive batches.");
        }
        Iterator iterator = sortArgs._in;
        if (sortArgs._fw > 0) {
            iterator = new FlyweightNodeIterator(sortArgs._fw, (Iterator<Node[]>)iterator);
        }
        Node[] nodeArray = null;
        while (iterator.hasNext()) {
            Node[] nodeArray2;
            iteratorArray = new TreeSet(sortArgs._nc);
            int n5 = 0;
            long l = System.currentTimeMillis();
            long l2 = Long.MAX_VALUE;
            int n6 = 0;
            while (iterator.hasNext() && (lowMemorySniffer != null && !lowMemorySniffer.lowMemory() || lowMemorySniffer == null && iteratorArray.size() < sortArgs._linesPerBatch)) {
                nodeArray2 = (Node[])iterator.next();
                n = iteratorArray.add(nodeArray2) ? 1 : 0;
                if (n == 0) {
                    ++n4;
                }
                ++n5;
                if (sortArgs._ticks > 0 && ++n2 % sortArgs._ticks == 0) {
                    _log.info("Batched " + n2 + " in " + n3 + " files with " + n4 + " duplicates.");
                }
                if (lowMemorySniffer == null || n2 % 5000 != 0) continue;
                long l3 = System.currentTimeMillis() - l;
                l = System.currentTimeMillis();
                if (l3 < l2) {
                    l2 = l3;
                    n6 = 0;
                    continue;
                }
                if ((double)l2 * 4.0 < (double)l3) {
                    if (++n6 < 3) continue;
                    _log.info("Slow mini-batch #" + n6 + " " + l3 + " vs. " + l2 + " fastest... batch size: " + iteratorArray.size());
                    break;
                }
                n6 = 0;
            }
            nodeArray2 = iteratorArray.iterator();
            if (!sortArgs._in.hasNext() && n3 == 0) {
                nodeArray = nodeArray2;
                break;
            }
            File file = new File(sortArgs._tmpDir + "/" + PREFIX + n3 + SUFFIX);
            OutputStream outputStream = new FileOutputStream(file);
            if (sortArgs._gzipBatch) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            CallbackNxBufferedWriter callbackNxBufferedWriter = new CallbackNxBufferedWriter(bufferedWriter);
            ++n3;
            _log.info("Dumping batch size: " + iteratorArray.size());
            while (nodeArray2.hasNext()) {
                Node[] nodeArray3 = (Node[])nodeArray2.next();
                callbackNxBufferedWriter.processStatement(nodeArray3);
            }
            bufferedWriter.close();
            _log.info("Parsed and sorted " + n2 + " lines in " + n3 + " files with " + n4 + " duplicates.");
        }
        if (n3 > 0) {
            _log.info("Merging " + n3 + " segment files.");
            iteratorArray = new Iterator[n3];
            InputStream[] inputStreamArray = new InputStream[n3];
            for (n = 0; n < n3; ++n) {
                String string = PREFIX + n + SUFFIX;
                inputStreamArray[n] = new FileInputStream(sortArgs._tmpDir + "/" + string);
                if (sortArgs._gzipBatch) {
                    inputStreamArray[n] = new GZIPInputStream(inputStreamArray[n], 8192);
                }
                iteratorArray[n] = new NxParser(inputStreamArray[n]);
            }
            MergeSortIterator.MergeSortArgs mergeSortArgs = new MergeSortIterator.MergeSortArgs(iteratorArray);
            mergeSortArgs.setComparator(sortArgs._nc);
            mergeSortArgs.setDuplicates(n4);
            mergeSortArgs.setTicks(sortArgs._ticks);
            this._merge = new MergeSortIterator(mergeSortArgs);
            this._dupes = this._merge.duplicates();
            for (int i = 0; i < n3; ++i) {
                String string = PREFIX + i + SUFFIX;
                File file = new File(sortArgs._tmpDir + "/" + string);
                file.delete();
            }
        } else if (nodeArray != null) {
            this._single = nodeArray;
            this._dupes = n4;
        }
    }

    public int duplicates() {
        if (this._merge == null && this._single == null) {
            return 0;
        }
        if (this._merge != null) {
            return this._merge.duplicates();
        }
        return this._dupes;
    }

    public int count() {
        return this._count;
    }

    @Override
    public boolean hasNext() {
        if (this._merge == null && this._single == null) {
            return false;
        }
        if (this._merge != null) {
            return this._merge.hasNext();
        }
        return this._single.hasNext();
    }

    @Override
    public Node[] next() {
        if (this._merge == null && this._single == null) {
            throw new NoSuchElementException();
        }
        if (this._merge != null) {
            ++this._count;
            return this._merge.next();
        }
        ++this._count;
        return this._single.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class SortArgs {
        public static final int DEFAULT_FW = 0;
        public static final boolean DEFAULT_GZIP_BATCH = true;
        public static final int ADAPTIVE_BATCHES = Integer.MIN_VALUE;
        private final Iterator<Node[]> _in;
        private final short _nxlength;
        private int _linesPerBatch;
        private Comparator<Node[]> _nc;
        private String _tmpDir;
        private boolean _gzipBatch = true;
        private int _ticks = 0;
        private int _fw = 0;

        public SortArgs(Iterator<Node[]> iterator) {
            SniffIterator sniffIterator;
            this._in = sniffIterator = new SniffIterator(iterator);
            this._nxlength = sniffIterator.nxLength();
            this.initDefaults(this._nxlength);
        }

        public SortArgs(Iterator<Node[]> iterator, short s) {
            this._in = iterator;
            this._nxlength = s;
            this.initDefaults(s);
        }

        public SortArgs(Iterator<Node[]> iterator, short s, int n) {
            this._in = iterator;
            this._nxlength = s;
            this._linesPerBatch = n;
            this._nc = NodeComparator.NC;
            this._tmpDir = Main.getTempSubDir();
            this._ticks = 0;
            this._fw = 0;
        }

        private void initDefaults(int n) {
            this._nc = NodeComparator.NC;
            this._tmpDir = Main.getTempSubDir();
            this._ticks = 0;
            this._fw = 0;
            this._linesPerBatch = this._nxlength > 0 ? MemoryManager.estimateMaxStatements(n) : 1;
        }

        public void setComparator(Comparator<Node[]> comparator) {
            this._nc = comparator;
        }

        public void setAdaptiveBatches() {
            this._linesPerBatch = Integer.MIN_VALUE;
        }

        public void setLinesPerBatch(int n) {
            this._linesPerBatch = n;
        }

        public void setGzipBatches(boolean bl) {
            this._gzipBatch = bl;
        }

        public void setTmpDir(String string) {
            this._tmpDir = Main.getTempSubDir(string);
        }

        public void setTicks(int n) {
            this._ticks = n;
        }

        public void setFlyWeight(int n) {
            this._fw = n;
        }
    }
}

