/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.sort;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;

public class MergeSortIterator
implements Iterator<Node[]> {
    static transient Logger _log = Logger.getLogger(MergeSortIterator.class.getName());
    private MergeSortArgs _args;
    private PriorityQueue<NodeArrayStreamPair> _q;
    private Node[] _current = null;
    private int _count = 0;
    private int _dupes;
    private NodeArrayStreamPair[] _last;

    public MergeSortIterator(Iterator<Node[]> ... iteratorArray) {
        this(new MergeSortArgs(iteratorArray));
    }

    public MergeSortIterator(MergeSortArgs mergeSortArgs) {
        this._args = mergeSortArgs;
        this._dupes = this._args._dupes;
        this._q = new PriorityQueue();
        this._last = new NodeArrayStreamPair[this._args._in.length];
        for (int i = 0; i < this._last.length; ++i) {
            this.loadNext(i);
        }
        if (this._q.size() == 0) {
            return;
        }
        this.prepareNext();
    }

    @Override
    public Node[] next() {
        Node[] nodeArray = new Node[this._current.length];
        System.arraycopy(this._current, 0, nodeArray, 0, this._current.length);
        this.prepareNext();
        return nodeArray;
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    private void prepareNext() {
        Node[] nodeArray = null;
        while (this._q.size() != 0) {
            NodeArrayStreamPair nodeArrayStreamPair = this._q.poll();
            nodeArray = nodeArrayStreamPair.getNodes();
            ++this._count;
            if (this._args._ticks > 0 && this._count % this._args._ticks == 0) {
                _log.info("Merged " + this._count + " with " + this._dupes + " duplicates.");
            }
            this.loadNext(nodeArrayStreamPair);
            if (this._current == null || this._args._nc.compare(this._current, nodeArray) != 0) {
                this._current = nodeArray;
                return;
            }
            ++this._dupes;
        }
        this._current = null;
    }

    private void loadNext(NodeArrayStreamPair nodeArrayStreamPair) {
        if (this._last[nodeArrayStreamPair.getStream()] != null && this._last[nodeArrayStreamPair.getStream()] == nodeArrayStreamPair) {
            this.loadNext(nodeArrayStreamPair.getStream());
        }
    }

    private void loadNext(int n) {
        NodeArrayStreamPair nodeArrayStreamPair = null;
        NodeArrayStreamPair nodeArrayStreamPair2 = null;
        Node[] nodeArray = null;
        int n2 = 0;
        for (int i = 0; i < this._args._linesPerBatch && this._args._in[n].hasNext(); ++i) {
            ++n2;
            nodeArray = (Node[])this._args._in[n].next();
            nodeArrayStreamPair = new NodeArrayStreamPair(nodeArray, n, this._args._nc);
            this._q.add(nodeArrayStreamPair);
            nodeArrayStreamPair2 = nodeArrayStreamPair;
        }
        this._last[n] = nodeArrayStreamPair2;
    }

    public int duplicates() {
        return this._dupes;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int count() {
        return this._count;
    }

    public static class MergeSortArgs {
        private final Iterator<Node[]>[] _in;
        private Comparator<Node[]> _nc = NodeComparator.NC;
        private int _linesPerBatch = 1;
        private int _dupes;
        private int _ticks = 0;

        public MergeSortArgs(Iterator<Node[]> ... iteratorArray) {
            this._in = iteratorArray;
            this._nc = NodeComparator.NC;
            this._linesPerBatch = 1;
            this._dupes = 0;
        }

        public void setComparator(Comparator<Node[]> comparator) {
            this._nc = comparator;
        }

        public void setLinesPerBatch(int n) {
            if (n > 0) {
                this._linesPerBatch = n;
            }
        }

        public void setDuplicates(int n) {
            this._dupes = n;
        }

        public void setTicks(int n) {
            this._ticks = n;
        }
    }

    private static class NodeArrayStreamPair
    implements Comparable<NodeArrayStreamPair> {
        private Node[] nodes;
        private int stream;
        private Comparator<Node[]> nc;

        private NodeArrayStreamPair(Node[] nodeArray, int n, Comparator<Node[]> comparator) {
            this.nodes = nodeArray;
            this.stream = n;
            this.nc = comparator;
        }

        public Node[] getNodes() {
            return this.nodes;
        }

        public int getStream() {
            return this.stream;
        }

        public void setNodes(Node[] nodeArray) {
            this.nodes = nodeArray;
        }

        public void setStream(int n) {
            this.stream = n;
        }

        @Override
        public int compareTo(NodeArrayStreamPair nodeArrayStreamPair) {
            return this.nc.compare(this.nodes, nodeArrayStreamPair.getNodes());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof NodeArrayStreamPair) {
                NodeArrayStreamPair nodeArrayStreamPair = (NodeArrayStreamPair)object;
                return this.nc.compare(this.nodes, nodeArrayStreamPair.nodes) == 0;
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not implemented.");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NodeStreamPair : Nodes :");
            for (Node node : this.nodes) {
                stringBuffer.append(node.toN3() + " ");
            }
            stringBuffer.append("Stream :" + this.stream);
            return stringBuffer.toString();
        }
    }
}

