/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.reorder;

import java.util.Iterator;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;

public class ReorderIterator
implements Iterator<Node[]> {
    static transient Logger _log = Logger.getLogger(ReorderIterator.class.getName());
    private final Iterator<Node[]> _in;
    private final int[] _order;
    private final int _ticks;
    private int _count;

    public ReorderIterator(Iterator<Node[]> iterator, int[] nArray) {
        this(iterator, nArray, 0);
    }

    public ReorderIterator(Iterator<Node[]> iterator, int[] nArray, int n) {
        this._in = iterator;
        this._order = nArray;
        this._ticks = n;
        this._count = 0;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    @Override
    public Node[] next() {
        ++this._count;
        if (this._ticks > 0 && this._count % this._ticks == 0) {
            _log.info("Reordered " + this._count + " statements.");
        }
        return ReorderIterator.reorder(this._in.next(), this._order);
    }

    @Override
    public void remove() {
        this._in.remove();
    }

    public int count() {
        return this._count;
    }

    public static Node[] reorder(Node[] nodeArray, int[] nArray) {
        Node[] nodeArray2 = new Node[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nodeArray2[i] = nodeArray[nArray[i]];
        }
        return nodeArray2;
    }

    public static int[] getInvOrder(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
        return nArray2;
    }
}

