/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.util.NxUtil;

public class NxParser
implements Iterator<Node[]>,
Iterable<Node[]> {
    private static Logger _log = Logger.getLogger(NxParser.class.getName());
    private int _lineNo = 0;
    private String _line = null;
    private Iterator<String> _stringIt = null;
    private Node[] next = null;
    @Deprecated
    public static boolean DEFAULT_PARSE_DTS = false;

    public NxParser(Reader reader) {
        this(new BufferedReader(reader));
    }

    public NxParser(InputStream inputStream, Charset charset) {
        this(new BufferedReader(new InputStreamReader(inputStream, charset)));
    }

    public NxParser(InputStream inputStream) {
        this(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public NxParser(BufferedReader bufferedReader) {
        this(NxParser.stringItFromBufferedReader(bufferedReader));
    }

    public NxParser(Iterable<String> iterable) {
        this(iterable.iterator());
    }

    public NxParser(Iterator<String> iterator) {
        this._stringIt = iterator;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Node[] next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Node[] nodeArray = this.next;
        this.loadNext();
        return nodeArray;
    }

    private void loadNext() {
        this.next = null;
        do {
            if (!this._stringIt.hasNext()) {
                this.next = null;
                return;
            }
            this._line = this._stringIt.next();
            ++this._lineNo;
        } while (this._line == null || NxParser.isEntirelyWhitespaceOrEmpty(this._line));
        try {
            this.next = NxParser.parseNodesInternal(this._line);
        }
        catch (Exception exception) {
            _log.warning("Moving on to the next line, as I couldn't parse line " + this._lineNo + ": " + this._line);
            exception.printStackTrace();
            this.loadNext();
        }
    }

    private static boolean isEntirelyWhitespaceOrEmpty(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        this._stringIt.remove();
    }

    @Override
    public Iterator<Node[]> iterator() {
        return this;
    }

    public static Node[] parseNodes(String string) throws ParseException {
        try {
            return NxParser.parseNodesInternal(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ParseException("Exception while parsing " + string);
        }
    }

    private static Node[] parseNodesInternal(String string) throws ParseException {
        int n = 0;
        int n2 = 0;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        while (true) {
            if (string.charAt(n) == ' ') {
                ++n;
                continue;
            }
            if (string.charAt(n) == '<') {
                n2 = string.indexOf(32, n);
                linkedList.add(new Resource(string.substring(n, n2), true));
            } else if (string.charAt(n) == '_') {
                n2 = string.indexOf(32, n);
                linkedList.add(new BNode(string.substring(n, n2), true));
            } else {
                if (string.charAt(n) == '.') break;
                if (string.charAt(n) == '\"') {
                    n2 = n;
                    while (string.charAt((n2 = string.indexOf(34, n2 + 1)) - 1) == '\\' && (n2 - 1 - NxParser.onlyCharUntil(string, '\\', n2 - 1)) % 2 == 0) {
                    }
                    while (string.charAt(n2) != ' ') {
                        ++n2;
                    }
                    linkedList.add(new Literal(string.substring(n, n2), true));
                } else if (string.charAt(n) == '?') {
                    n2 = string.indexOf(32, n);
                    linkedList.add(new Variable(string.substring(n, n2), true));
                } else if (string.charAt(n) == "UNBOUND".charAt(0) && string.substring(n, n + "UNBOUND".length()).equals("UNBOUND")) {
                    linkedList.add(new Unbound());
                    n2 = string.indexOf(32, n);
                }
            }
            if (n == n2 + 1) {
                throw new ParseException("Exception at position " + n2 + " while parsing " + string);
            }
            n = n2 + 1;
        }
        return linkedList.toArray(new Node[linkedList.size()]);
    }

    private static int onlyCharUntil(String string, char c, int n) {
        while (string.charAt(n) == c) {
            --n;
        }
        return n + 1;
    }

    private static Iterator<String> stringItFromBufferedReader(final BufferedReader bufferedReader) {
        return new Iterator<String>(){
            boolean nextIsFetched = true;
            String next = null;

            @Override
            public boolean hasNext() {
                if (!this.nextIsFetched) {
                    return this.next != null;
                }
                try {
                    this.next = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.next = null;
                }
                this.nextIsFetched = false;
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.nextIsFetched) {
                    try {
                        this.next = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.nextIsFetched = true;
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int lineNumber() {
        return this._lineNo;
    }

    @Deprecated
    public NxParser(Reader reader, boolean bl) {
        this(reader);
    }

    @Deprecated
    public NxParser(Reader reader, boolean bl, boolean bl2) {
        this(reader);
    }

    @Deprecated
    public NxParser(InputStream inputStream, boolean bl, boolean bl2) {
        this(inputStream);
    }

    @Deprecated
    public NxParser(InputStream inputStream, boolean bl) {
        this(inputStream);
    }

    @Deprecated
    public static Node[] parseNodes(String string, boolean bl) throws ParseException {
        return NxParser.parseNodes(string);
    }

    @Deprecated
    public static Literal parseLiteral(String string) throws ParseException {
        return NxParser.parseLiteral(string, DEFAULT_PARSE_DTS);
    }

    @Deprecated
    public static Literal parseLiteral(String string, boolean bl) throws ParseException {
        if (string.charAt(0) != '\"') {
            throw new ParseException("literal must be enclosed with \"\"");
        }
        return new Literal(string, true);
    }

    @Deprecated
    public static Variable parseVariable(String string) throws ParseException {
        if (string.charAt(0) != '?') {
            throw new ParseException("variable must start with ?");
        }
        return new Variable(string, true);
    }

    @Deprecated
    public static Resource parseResource(String string) throws ParseException {
        if (string.charAt(0) != '<' && string.charAt(string.length() - 1) != '>') {
            throw new ParseException("resource must be enclosed with <>");
        }
        return new Resource(string, true);
    }

    @Deprecated
    public static BNode parseBNode(String string) throws ParseException {
        if (string.charAt(0) != '_' || string.charAt(1) != ':') {
            throw new ParseException("bnode must start with :_");
        }
        return new BNode(string, true);
    }

    @Deprecated
    public static Node parseNode(String string) throws ParseException {
        return NxParser.parseNode(string, DEFAULT_PARSE_DTS);
    }

    @Deprecated
    public static Node parseNode(String string, boolean bl) throws ParseException {
        if (string.charAt(0) == '_') {
            return NxParser.parseBNode(string);
        }
        if (string.charAt(0) == '<') {
            return NxParser.parseResource(string);
        }
        if (string.charAt(0) == '\"') {
            return NxParser.parseLiteral(string, bl);
        }
        if (string.charAt(0) == '?') {
            return NxParser.parseVariable(string);
        }
        throw new ParseException("cannot parse " + string);
    }

    @Deprecated
    public static String escapeForNx(String string) {
        return NxUtil.escapeForNx(string);
    }

    @Deprecated
    public static String escapeForMarkup(String string) {
        return NxUtil.escapeForMarkup(string);
    }

    @Deprecated
    public static String unescape(String string) {
        return NxUtil.unescape(string, false);
    }

    @Deprecated
    public static String unescape(String string, boolean bl) {
        return NxUtil.unescape(string, bl);
    }
}

