/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.mem;

public class MemoryManager {
    public static final int NODES_PER_MB_IN_MEM = 1024;

    public static final long estimateHeapSpace() {
        long l = Runtime.getRuntime().maxMemory();
        if (l == Long.MAX_VALUE) {
            l = Runtime.getRuntime().freeMemory();
        }
        return l;
    }

    public static final long estimateFreeSpace() {
        System.gc();
        long l = Runtime.getRuntime().maxMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        return l3 + (l - l2);
    }

    public static final int estimateMaxNodes() {
        return (int)(MemoryManager.estimateFreeSpace() / 0x100000L * 1024L);
    }

    public static final int estimateMaxStatements(int n) {
        return (int)(MemoryManager.estimateFreeSpace() / 0x100000L * (long)(1024 / n));
    }
}

