/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.hash;

public class HashLibrary {
    public static long RSHash(String string) {
        int n = 378551;
        int n2 = 63689;
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = l * (long)n2 + (long)string.charAt(i);
            n2 *= n;
        }
        return l;
    }

    public static long JSHash(String string) {
        long l = 1315423911L;
        for (int i = 0; i < string.length(); ++i) {
            l ^= (l << 5) + (long)string.charAt(i) + (l >> 2);
        }
        return l;
    }

    public static long PJWHash(String string) {
        long l = 32L;
        long l2 = l * 3L / 4L;
        long l3 = l / 8L;
        long l4 = -1L << (int)(l - l3);
        long l5 = 0L;
        long l6 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l6 = (l5 = (l5 << (int)l3) + (long)string.charAt(i)) & l4;
            if (l6 == 0L) continue;
            l5 = (l5 ^ l6 >> (int)l2) & (l4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return l5;
    }

    public static long ELFHash(String string) {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 = (l = (l << 4) + (long)string.charAt(i)) & 0xF0000000L;
            if (l2 != 0L) {
                l ^= l2 >> 24;
            }
            l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public static long BKDRHash(String string) {
        long l = 131L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 = l2 * l + (long)string.charAt(i);
        }
        return l2;
    }

    public static long SDBMHash(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = (long)string.charAt(i) + (l << 6) + (l << 16) - l;
        }
        return l;
    }

    public static long DJBHash(String string) {
        long l = 5381L;
        for (int i = 0; i < string.length(); ++i) {
            l = (l << 5) + l + (long)string.charAt(i);
        }
        return l;
    }

    public static long JavaHash(String string) {
        long l = 31L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 = l2 * l + (long)string.charAt(i);
        }
        return l2;
    }

    public static long DEKHash(String string) {
        long l = string.length();
        for (int i = 0; i < string.length(); ++i) {
            l = l << 5 ^ l >> 27 ^ (long)string.charAt(i);
        }
        return l;
    }

    public static long BPHash(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = l << 7 ^ (long)string.charAt(i);
        }
        return l;
    }

    public static long FNVHash(String string) {
        long l = -2128831035L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 *= l;
            l2 ^= (long)string.charAt(i);
        }
        return l2;
    }

    public static long APHash(String string) {
        long l = -1431655766L;
        for (int i = 0; i < string.length(); ++i) {
            if ((i & 1) == 0) {
                l ^= l << 7 ^ (long)string.charAt(i) * (l >> 3);
                continue;
            }
            l ^= (l << 11) + (long)string.charAt(i) ^ l >> 5 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public static long hashCode(String string) {
        return HashLibrary.JavaHash(string);
    }
}

