/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.filter;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Node;

public interface NodeFilter {
    public boolean check(Node var1);

    public static class OrFilter
    implements NodeFilter {
        NodeFilter[] _filters;

        public OrFilter(NodeFilter ... nodeFilterArray) {
            this._filters = nodeFilterArray;
        }

        @Override
        public boolean check(Node node) {
            for (NodeFilter nodeFilter : this._filters) {
                if (!nodeFilter.check(node)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndFilter
    implements NodeFilter {
        NodeFilter[] _filters;

        public AndFilter(NodeFilter ... nodeFilterArray) {
            this._filters = nodeFilterArray;
        }

        @Override
        public boolean check(Node node) {
            for (NodeFilter nodeFilter : this._filters) {
                if (nodeFilter.check(node)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ClassFilter
    extends AbstractFilter {
        Class<? extends Node> _class;

        public ClassFilter(Class<? extends Node> clazz) {
            this(clazz, false);
        }

        public ClassFilter(Class<? extends Node> clazz, boolean bl) {
            super(bl);
            this._class = clazz;
        }

        @Override
        protected boolean matches(Node node) {
            return this._class.isInstance(node);
        }
    }

    public static class RegexFilter
    extends AbstractFilter {
        Pattern _pattern;
        public static final char CASE_INSENSITIVE = 'i';
        public static final char DOT_ALL = 's';
        public static final char MULTI_LINE = 'm';
        public static final char REMOVE_WHITESPACE = 'x';

        public RegexFilter(String string, int n) {
            this(string, n, false);
        }

        public RegexFilter(String string, int n, boolean bl) {
            super(bl);
            this._pattern = Pattern.compile(string, n);
        }

        public RegexFilter(String string) {
            this(string, false);
        }

        public RegexFilter(String string, boolean bl) {
            super(bl);
            this._pattern = Pattern.compile(string);
        }

        @Override
        protected boolean matches(Node node) {
            return this._pattern.matcher(node.toString()).matches();
        }

        public RegexFilter(String string, String string2) {
            this(string, string2, false);
        }

        public RegexFilter(String string, String string2, boolean bl) {
            super(bl);
            if (string2 != null && string2.trim().length() > 0) {
                int n;
                int n2;
                string2 = string2.trim();
                int[] nArray = new int[string2.length()];
                for (n2 = 0; n2 < string2.length(); ++n2) {
                    n = string2.charAt(n2);
                    if (n == 105) {
                        nArray[n2] = 2;
                        continue;
                    }
                    if (n == 115) {
                        nArray[n2] = 32;
                        continue;
                    }
                    if (n == 109) {
                        nArray[n2] = 8;
                        continue;
                    }
                    if (n == 120) {
                        nArray[n2] = 4;
                        continue;
                    }
                    throw new IllegalArgumentException("Cannot recognise REGEX flag :" + string2 + "." + "Must be " + 'i' + " " + 's' + " " + 'm' + " or " + 'x');
                }
                n2 = 0;
                if (nArray != null && nArray.length != 0) {
                    if (nArray.length == 1) {
                        n2 = nArray[0];
                    } else {
                        n2 = nArray[0];
                        for (n = 1; n < nArray.length; ++n) {
                            n2 |= nArray[n];
                        }
                    }
                }
                this._pattern = Pattern.compile(string, n2);
            } else {
                this._pattern = Pattern.compile(string);
            }
        }
    }

    public static class PrefixFilter
    extends AbstractFilter {
        String _namespace;

        public PrefixFilter(String string) {
            this(string, false);
        }

        public PrefixFilter(String string, boolean bl) {
            super(bl);
            this._namespace = string;
        }

        @Override
        protected boolean matches(Node node) {
            return node.toString().startsWith(this._namespace);
        }
    }

    public static class EqualsFilter
    extends AbstractFilter {
        String _equals;

        public EqualsFilter(String string, boolean bl) {
            super(bl);
            this._equals = string;
        }

        public EqualsFilter(String string) {
            this(string, false);
        }

        @Override
        protected boolean matches(Node node) {
            return this._equals.equals(node.toString());
        }
    }

    public static abstract class AbstractFilter
    implements NodeFilter {
        boolean _negate;

        protected AbstractFilter(boolean bl) {
            this._negate = bl;
        }

        protected AbstractFilter() {
            this._negate = false;
        }

        @Override
        public final boolean check(Node node) {
            return this._negate ^ this.matches(node);
        }

        protected abstract boolean matches(Node var1);
    }
}

