/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.file.FileInput;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars2.rdfxml.RDFXMLParser;

public class RDFXMLGzInput
extends FileInput {
    public static int BUFFER = 8192;
    private String _base;

    public RDFXMLGzInput(File file, String string) throws ParseException {
        super(file);
        this._base = string;
        this._in = this.openFile();
    }

    @Override
    protected Iterator<Node[]> openFile() {
        if (this._base != null) {
            return this.openFile(this._base);
        }
        return null;
    }

    protected Iterator<Node[]> openFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(this._f);
            GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)fileInputStream, BUFFER);
            this.toClose(gZIPInputStream);
            RDFXMLParser rDFXMLParser = new RDFXMLParser(gZIPInputStream, string);
            return rDFXMLParser;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public RDFXMLGzInput copyOf() throws ParseException {
        return new RDFXMLGzInput(this._f, this._base);
    }
}

