/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.uri;

import java.net.URI;
import java.net.URISyntaxException;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDAnyURI
extends Datatype<URI> {
    public static final Resource DT = XSD.ANYURI;
    private URI _u;

    public XSDAnyURI(String string) throws DatatypeParseException {
        try {
            string = string.replaceAll(" ", "%20");
            this._u = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DatatypeParseException("Error parsing URI: " + uRISyntaxException.getMessage() + ".", string, DT, 2);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._u.toString();
    }

    @Override
    public URI getValue() {
        return this._u;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDAnyURI xSDAnyURI = new XSDAnyURI("http://blah.com/asdj asd/aofds");
        System.err.println(xSDAnyURI.getCanonicalRepresentation());
    }
}

