/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.string;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDToken
extends Datatype<String> {
    public static final Resource DT = XSD.TOKEN;
    private String _ns;
    public static final String REGEX = "[^\\n\\t\\r ]?|[^\\n\\t\\r ][^\\n\\t\\r ]|[^ \\n\\t\\r][^\\n\\t\\r]*[^ \\n\\t\\r]";

    public XSDToken(String string) throws DatatypeParseException {
        if (!string.isEmpty() && !Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [^\\n\\t\\r ]?|[^\\n\\t\\r ][^\\n\\t\\r ]|[^ \\n\\t\\r][^\\n\\t\\r]*[^ \\n\\t\\r].", string, DT, 20);
        }
        if (string.contains("  ")) {
            throw new DatatypeParseException("Lexical value should not contain a double-space.", string, DT, 21);
        }
        this._ns = string;
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ns;
    }

    @Override
    public String getValue() {
        return this._ns;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDToken xSDToken = new XSDToken("a b");
        System.err.println(xSDToken.getCanonicalRepresentation());
        System.err.println(xSDToken.getValue());
    }
}

