/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.string;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDNormalisedString
extends Datatype<String> {
    public static final Resource DT = XSD.NORMALIZEDSTRING;
    private String _ns;
    public static final String REGEX = "[^\\t^\\r^\\n]*";

    public XSDNormalisedString(String string) throws DatatypeParseException {
        if (string == null) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [^\\t^\\r^\\n]*.", string, DT, 2);
        }
        this._ns = string;
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ns;
    }

    @Override
    public String getValue() {
        return this._ns.replace("\n", " ");
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDNormalisedString xSDNormalisedString = new XSDNormalisedString("");
        System.err.println(xSDNormalisedString.getCanonicalRepresentation());
        System.err.println(xSDNormalisedString.getValue());
    }
}

