/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.string;

import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDLanguage
extends Datatype<Locale> {
    public static final Resource DT = XSD.LANGUAGE;
    public static final String REGEX = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    private Locale _l;
    private String _s;

    public XSDLanguage(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*.", string, DT, 20);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() == 0) {
            throw new DatatypeParseException("Cannot parse according to '-'.", string, DT, 21);
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.length() != 2) {
            throw new DatatypeParseException("Expecting first token to be of length 2: '" + string2 + "'.", string, DT, 22);
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this._l = stringTokenizer.hasMoreTokens() ? new Locale(string2, string3, stringTokenizer.nextToken()) : new Locale(string2, string3);
        } else {
            this._l = new Locale(string2);
        }
        this._s = string;
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._s;
    }

    @Override
    public Locale getValue() {
        return this._l;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDLanguage xSDLanguage = new XSDLanguage("en-US-asdjf");
        System.err.println(xSDLanguage.getCanonicalRepresentation());
        System.err.println(xSDLanguage.getValue());
    }
}

