/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDUnsignedLong
extends Datatype<BigInteger> {
    public static final Resource DT = XSD.UNSIGNEDLONG;
    private BigInteger _ul;
    private static final BigInteger MAX_INCLUSIVE = new BigInteger("18446744073709551615");
    private static final BigInteger MIN_INCLUSIVE = new BigInteger("0");
    public static final String REGEX = "(\\+|-)?[0-9]+";

    public XSDUnsignedLong(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex (\\+|-)?[0-9]+.", string, DT, 20);
        }
        try {
            if (string.startsWith("+")) {
                string = string.substring(1, string.length());
            }
            this._ul = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing BigInteger (unsigned long): " + numberFormatException.getMessage() + ".", string, DT, 21);
        }
        if (this._ul.compareTo(MAX_INCLUSIVE) > 0) {
            throw new DatatypeParseException("Value of unsigned long above max_inclusive value " + MAX_INCLUSIVE + ".", string, DT, 40);
        }
        if (this._ul.compareTo(MIN_INCLUSIVE) < 0) {
            throw new DatatypeParseException("Value of unsigned long below min_inclusive value " + MIN_INCLUSIVE + ".", string, DT, 42);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ul.toString();
    }

    @Override
    public BigInteger getValue() {
        return this._ul;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDUnsignedLong xSDUnsignedLong = new XSDUnsignedLong("+2345276324514325326532514321");
        System.err.println(xSDUnsignedLong.getCanonicalRepresentation());
    }
}

