/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDUnsignedInt
extends Datatype<Long> {
    public static final Resource DT = XSD.UNSIGNEDINT;
    private Long _ui;
    private static final long MAX_INCLUSIVE = Long.parseLong("4294967295");
    private static final long MIN_INCLUSIVE = 0L;
    public static final String REGEX = "(\\+|-)?[0-9]+";

    public XSDUnsignedInt(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex (\\+|-)?[0-9]+.", string, DT, 20);
        }
        try {
            if (string.startsWith("+")) {
                string = string.substring(1, string.length());
            }
            this._ui = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing long (unsigned int): " + numberFormatException.getMessage() + ".", string, DT, 40);
        }
        if (this._ui > MAX_INCLUSIVE) {
            throw new DatatypeParseException("Value of unsigned int above max_inclusive value " + MAX_INCLUSIVE + ".", string, DT, 41);
        }
        if (this._ui < 0L) {
            throw new DatatypeParseException("Value of unsigned int below min_inclusive value 0.", string, DT, 42);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ui.toString();
    }

    @Override
    public Long getValue() {
        return this._ui;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDUnsignedInt xSDUnsignedInt = new XSDUnsignedInt("2334523445");
        System.err.println(xSDUnsignedInt.getCanonicalRepresentation());
    }
}

