/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDUnsignedByte
extends Datatype<Short> {
    public static final Resource DT = XSD.UNSIGNEDBYTE;
    private Short _ub;
    private static final short MAX_INCLUSIVE = 255;
    private static final short MIN_INCLUSIVE = 0;
    public static final String REGEX = "(\\+|-)?[0-9]+";

    public XSDUnsignedByte(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex (\\+|-)?[0-9]+.", string, DT, 20);
        }
        try {
            if (string.startsWith("+")) {
                string = string.substring(1, string.length());
            }
            this._ub = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing short (unsigned byte): " + numberFormatException.getMessage() + ".", string, DT, 40);
        }
        if (this._ub > 255) {
            throw new DatatypeParseException("Value of unsigned byte above max_inclusive value 255.", string, DT, 41);
        }
        if (this._ub < 0) {
            throw new DatatypeParseException("Value of unsigned byte below min_inclusive value 0.", string, DT, 42);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ub.toString();
    }

    @Override
    public Short getValue() {
        return this._ub;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDUnsignedByte xSDUnsignedByte = new XSDUnsignedByte("+42");
        System.err.println(xSDUnsignedByte.getCanonicalRepresentation());
    }
}

