/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDShort
extends Datatype<Short> {
    public static final Resource DT = XSD.SHORT;
    private short _s;
    public static final String REGEX = "[+-]?[0-9]*";

    public XSDShort(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*.", string, DT, 2);
        }
        try {
            this._s = !string.startsWith("+") ? Short.parseShort(string) : Short.parseShort(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing short: " + numberFormatException.getMessage() + ".", string, DT, 4);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return Short.toString(this._s);
    }

    @Override
    public Short getValue() {
        return this._s;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDShort xSDShort = new XSDShort("-32767");
        System.err.println(xSDShort.getCanonicalRepresentation());
    }
}

