/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDNegativeInteger
extends Datatype<BigInteger> {
    public static final Resource DT = XSD.NEGATIVEINTEGER;
    private BigInteger _bi;
    public static final String REGEX = "[-][0-9]*";

    public XSDNegativeInteger(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [-][0-9]*.", string, DT, 20);
        }
        try {
            this._bi = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing BigInteger: " + numberFormatException.getMessage() + ".", string, DT, 21);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._bi.toString();
    }

    @Override
    public BigInteger getValue() {
        return this._bi;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDNegativeInteger xSDNegativeInteger = new XSDNegativeInteger("-1876");
        System.err.println(xSDNegativeInteger.getCanonicalRepresentation());
    }
}

