/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDLong
extends Datatype<Long> {
    public static final Resource DT = XSD.LONG;
    private long _l;
    public static final String REGEX = "[+-]?[0-9]*";

    public XSDLong(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*.", string, DT, 2);
        }
        try {
            this._l = !string.startsWith("+") ? Long.parseLong(string) : Long.parseLong(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing long: " + numberFormatException.getMessage() + ".", string, DT, 4);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return Long.toString(this._l);
    }

    @Override
    public Long getValue() {
        return this._l;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDLong xSDLong = new XSDLong("+9223372036854775807");
        System.err.println(xSDLong.getCanonicalRepresentation());
    }
}

