/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDInt
extends Datatype<Integer> {
    public static final Resource DT = XSD.INT;
    private int _i;
    public static final String REGEX = "[+-]?[0-9]*";

    public XSDInt(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*.", string, DT, 2);
        }
        try {
            this._i = !string.startsWith("+") ? Integer.parseInt(string) : Integer.parseInt(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing int: " + numberFormatException.getMessage() + ".", string, DT, 4);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return Integer.toString(this._i);
    }

    @Override
    public Integer getValue() {
        return this._i;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDInt xSDInt = new XSDInt("-0");
        System.err.println(xSDInt.getCanonicalRepresentation());
    }
}

