/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDFloat
extends Datatype<Float> {
    public static final Resource DT = XSD.FLOAT;
    private float _f;
    private static final String REGEX = "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?|(\\+|-)?INF|NaN";
    private static final String POSITIVE_NUMBER = ".*[1-9].*";

    public XSDFloat(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        try {
            if (!Pattern.matches(REGEX, string)) {
                throw new DatatypeParseException("Lexical value does not correspond to regex (\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?|(\\+|-)?INF|NaN.", string, DT, 2);
            }
            if (string.equals("INF")) {
                this._f = Float.POSITIVE_INFINITY;
            } else if (string.equals("-INF")) {
                this._f = Float.NEGATIVE_INFINITY;
            } else {
                this._f = Float.parseFloat(string);
                if (this._f == Float.POSITIVE_INFINITY) {
                    throw new DatatypeParseException("Error parsing float: exceeds POSITIVE MAX of 3.4028235E38.", string, DT, 2);
                }
                if (this._f == Float.NEGATIVE_INFINITY) {
                    throw new DatatypeParseException("Error parsing float: exceeds NEGATIVE MAX of -3.4028235E38.", string, DT, 2);
                }
                if (this._f == 0.0f && string.matches(POSITIVE_NUMBER)) {
                    throw new DatatypeParseException("Error parsing float: exceeds MIN of 1.4E-45.", string, DT, 2);
                }
            }
            this._f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing float: " + numberFormatException.getMessage() + ".", string, DT, 2);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        if (this._f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (this._f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return Float.toString(this._f);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this._f);
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDFloat xSDFloat = new XSDFloat("12.78e-500");
        System.err.println(xSDFloat.getCanonicalRepresentation());
    }
}

