/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDDouble
extends Datatype<Double> {
    public static final Resource DT = XSD.DOUBLE;
    private double _d;
    private static final String REGEX = "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?|(\\+|-)?INF|NaN";
    private static final String POSITIVE_NUMBER = ".*[1-9].*";

    public XSDDouble(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        try {
            if (!Pattern.matches(REGEX, string)) {
                throw new DatatypeParseException("Lexical value does not correspond to regex (\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?|(\\+|-)?INF|NaN.", string, DT, 2);
            }
            if (string.equals("INF")) {
                this._d = Double.POSITIVE_INFINITY;
            } else if (string.equals("-INF")) {
                this._d = Double.NEGATIVE_INFINITY;
            } else {
                this._d = Double.parseDouble(string);
                if (this._d == Double.POSITIVE_INFINITY) {
                    throw new DatatypeParseException("Error parsing double: exceeds POSITIVE MAX of 1.7976931348623157E308.", string, DT, 2);
                }
                if (this._d == Double.NEGATIVE_INFINITY) {
                    throw new DatatypeParseException("Error parsing double: exceeds NEGATIVE MAX of -1.7976931348623157E308.", string, DT, 2);
                }
                if (this._d == 0.0 && string.matches(POSITIVE_NUMBER)) {
                    throw new DatatypeParseException("Error parsing double: exceeds MIN of 4.9E-324.", string, DT, 2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing double: " + numberFormatException.getMessage() + ".", string, DT, 2);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        if (this._d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (this._d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return Double.toString(this._d);
    }

    @Override
    public Double getValue() {
        return this._d;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDDouble xSDDouble = new XSDDouble("1420e-12");
        System.err.println(xSDDouble.getCanonicalRepresentation());
    }
}

