/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDDecimal
extends Datatype<BigDecimal> {
    public static final Resource DT = XSD.DECIMAL;
    private BigDecimal _bd;
    public static final String REGEX = "[+-]?[0-9]*[.]?[0-9]*";

    public XSDDecimal(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*[.]?[0-9]*.", string, DT, 20);
        }
        try {
            this._bd = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing BigDecimal: " + numberFormatException.getMessage() + ".", string, DT, 21);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        if (this._bd.scale() == 0) {
            return this._bd.toPlainString() + ".0";
        }
        return XSDDecimal.removeTrailingZeros(this._bd.toPlainString());
    }

    public static String removeTrailingZeros(String string) {
        String string2 = string;
        while (string2.endsWith("0") && !string2.isEmpty() && string2.charAt(string2.length() - 2) != '.') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Override
    public BigDecimal getValue() {
        return this._bd;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDDecimal xSDDecimal = new XSDDecimal("-2345236524533245234523532235645345627.2340");
        System.err.println(xSDDecimal.getCanonicalRepresentation());
    }
}

