/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDByte
extends Datatype<Byte> {
    public static final Resource DT = XSD.BYTE;
    private byte _b;
    public static final String REGEX = "[+-]?[0-9]*";

    public XSDByte(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*.", string, DT, 20);
        }
        try {
            this._b = !string.startsWith("+") ? Byte.parseByte(string) : Byte.parseByte(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Error parsing byte: " + numberFormatException.getMessage() + ".", string, DT, 21);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return Byte.toString(this._b);
    }

    @Override
    public Byte getValue() {
        return this._b;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDByte xSDByte = new XSDByte("-67");
        System.err.println(xSDByte.getCanonicalRepresentation());
    }
}

