/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.datetime;

import java.util.GregorianCalendar;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.datetime.ISO8601Parser;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDDateTimeStamp
extends Datatype<GregorianCalendar> {
    public static final Resource DT = XSD.DATETIME;
    private GregorianCalendar _cal;

    public XSDDateTimeStamp(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        try {
            this._cal = ISO8601Parser.parseISO8601DateTime(string, true);
        }
        catch (DatatypeParseException datatypeParseException) {
            throw new DatatypeParseException(datatypeParseException.getMessage(), string, DT, datatypeParseException.getError());
        }
    }

    @Override
    public GregorianCalendar getValue() {
        return this._cal;
    }

    @Override
    public String getCanonicalRepresentation() {
        return ISO8601Parser.getCanonicalRepresentation(this.getValue(), true, true, true, true, true);
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDDateTimeStamp xSDDateTimeStamp = new XSDDateTimeStamp("1600-02-29T07:17:55Z");
        System.err.println(xSDDateTimeStamp.getCanonicalRepresentation());
    }

    public static String leadZeros(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }
}

