/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.datetime;

import java.util.GregorianCalendar;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.datetime.ISO8601Parser;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDDateTime
extends Datatype<GregorianCalendar> {
    public static final Resource DT = XSD.DATETIME;
    private GregorianCalendar _cal;

    public XSDDateTime(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        try {
            this._cal = ISO8601Parser.parseISO8601DateTime(string);
        }
        catch (DatatypeParseException datatypeParseException) {
            throw new DatatypeParseException(datatypeParseException.getMessage(), string, DT, datatypeParseException.getError());
        }
    }

    @Override
    public GregorianCalendar getValue() {
        return this._cal;
    }

    @Override
    public String getCanonicalRepresentation() {
        return ISO8601Parser.getCanonicalRepresentation(this.getValue(), true, true, true, true, true);
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDDateTime xSDDateTime = new XSDDateTime("1600-02-29T07:17:55Z");
        System.err.println(xSDDateTime.getCanonicalRepresentation());
    }

    public static String leadZeros(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }
}

