/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.datetime;

import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.datetime.XSDTime;

public class ISO8601Parser {
    private static String NO_TOKEN = "\n";

    public static GregorianCalendar parseISO8601DateTime(String string) throws DatatypeParseException {
        return ISO8601Parser.parseISO8601DateTime(string, false);
    }

    public static GregorianCalendar parseISO8601DateTime(String string, boolean bl) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        String string2 = ISO8601Parser.parseISO8601Date(string, gregorianCalendar);
        if (string2 == null) {
            throw new DatatypeParseException("Premature end of lexical string, expecting token 'T'.", 101);
        }
        if (!string2.startsWith("T")) {
            throw new DatatypeParseException("Expecting token 'T', not '" + string2 + "'.", 201);
        }
        String string3 = ISO8601Parser.parseISO8601Time(string2.substring(1), gregorianCalendar);
        if (string3 == null) {
            if (bl) {
                throw new DatatypeParseException("Premature end of lexical string, expecting token '.*(Z|(\\+|-)[0-9][0-9]:[0-9][0-9])'.", 101);
            }
        } else {
            String string4 = ISO8601Parser.parseISO8601Timezone(string3, gregorianCalendar);
            if (string4 != null) {
                throw new DatatypeParseException("Expecting end of lexical string, not '" + string4 + "'.", 301);
            }
        }
        return gregorianCalendar;
    }

    public static GregorianCalendar parseISO8601Date(String string) throws DatatypeParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        String string2 = ISO8601Parser.parseISO8601Date(string, gregorianCalendar);
        if (string2 != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + string2 + "'.", 302);
        }
        return gregorianCalendar;
    }

    private static String parseISO8601Date(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        String string2 = ISO8601Parser.parseISO8601Year(string, gregorianCalendar);
        if (string2 == null || !string2.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + string2 + "'.", 202);
        }
        String string3 = ISO8601Parser.parseISO8601Month(string2.substring(1), gregorianCalendar);
        if (string3 == null || !string3.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + string3 + "'.", 203);
        }
        String string4 = ISO8601Parser.parseISO8601Day(string3.substring(1), gregorianCalendar);
        if (string4 == null) {
            return null;
        }
        if (string4.startsWith("T")) {
            return string4;
        }
        String string5 = ISO8601Parser.parseISO8601Timezone(string4, gregorianCalendar);
        return string5;
    }

    public static GregorianCalendar parseISO8601YearMonth(String string) throws DatatypeParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        String string2 = ISO8601Parser.parseISO8601YearMonth(string, gregorianCalendar);
        if (string2 != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + string2 + "'.", 303);
        }
        return gregorianCalendar;
    }

    private static String parseISO8601YearMonth(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        String string2 = ISO8601Parser.parseISO8601Year(string, gregorianCalendar);
        if (string2 == null || !string2.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + string2 + "'.", 204);
        }
        String string3 = ISO8601Parser.parseISO8601Month(string2.substring(1), gregorianCalendar);
        if (string3 == null) {
            return null;
        }
        String string4 = ISO8601Parser.parseISO8601Timezone(string3, gregorianCalendar);
        return string4;
    }

    public static GregorianCalendar parseISO8601Year(String string) throws DatatypeParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        String string2 = ISO8601Parser.parseISO8601Year(string, gregorianCalendar);
        if (string2 == null) {
            return gregorianCalendar;
        }
        String string3 = ISO8601Parser.parseISO8601Timezone(string2, gregorianCalendar);
        if (string3 != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + string3 + "'.", 304);
        }
        return gregorianCalendar;
    }

    private static String parseISO8601Year(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        int n;
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-+Z", true);
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("-")) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'YYYY'.", 102);
            }
            string2 = stringTokenizer.nextToken();
            gregorianCalendar.set(0, 0);
        } else if (string2.equals("+")) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'YYYY'.", 103);
            }
            string2 = stringTokenizer.nextToken();
        }
        if (string2.length() < 4) {
            throw new DatatypeParseException("Illegal value for YYYY '" + string2 + "'. Min length is 4.", 223);
        }
        if (string2.length() > 4 && string2.startsWith("0")) {
            throw new DatatypeParseException("Illegal value for YYYY '" + string2 + "'. Leading zeros only allowed for YYYY length of 4.", 223);
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Illegal value for YYYY '" + string2 + "'.", 205);
        }
        gregorianCalendar.set(1, n);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return stringTokenizer.nextToken(NO_TOKEN);
    }

    public static GregorianCalendar parseISO8601MonthDay(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        if (!string.startsWith("--")) {
            throw new DatatypeParseException("Expecting opening token '--' not '" + string + "'.", 206);
        }
        String string2 = ISO8601Parser.parseISO8601MonthDay(string.substring(2), gregorianCalendar);
        if (string2 != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + string2 + "'.", 305);
        }
        return gregorianCalendar;
    }

    private static String parseISO8601MonthDay(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        String string2 = ISO8601Parser.parseISO8601Month(string, gregorianCalendar);
        if (string2 == null || !string2.startsWith("-")) {
            throw new DatatypeParseException("Expecting token '-' not '" + string2 + "'.", 207);
        }
        String string3 = ISO8601Parser.parseISO8601Day(string2.substring(1), gregorianCalendar);
        if (string3 == null) {
            return null;
        }
        String string4 = ISO8601Parser.parseISO8601Timezone(string3, gregorianCalendar);
        return string4;
    }

    public static GregorianCalendar parseISO8601Month(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        if (!string.startsWith("--")) {
            throw new DatatypeParseException("Expecting opening token '--' not '" + string + "'.", 208);
        }
        if (!string.endsWith("--")) {
            throw new DatatypeParseException("Expecting closing token '--' not '" + string + "'.", 209);
        }
        String string2 = ISO8601Parser.parseISO8601Month(string.substring(2, string.length() - 2), gregorianCalendar);
        if (string2 == null) {
            return gregorianCalendar;
        }
        String string3 = ISO8601Parser.parseISO8601Timezone(string2, gregorianCalendar);
        if (string3 != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + string3 + "'.", 306);
        }
        return gregorianCalendar;
    }

    private static String parseISO8601Month(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        int n;
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-+Z", true);
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Illegal value for MM: '" + string2 + "'.", 210);
        }
        if (n > 12 || n < 1) {
            throw new DatatypeParseException("Illegal value for MM (>12): " + n + ".", 401);
        }
        gregorianCalendar.set(2, n - 1);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return stringTokenizer.nextToken(NO_TOKEN);
    }

    public static GregorianCalendar parseISO8601Day(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        if (!string.startsWith("---")) {
            throw new DatatypeParseException("Expecting opening token '---' not '" + string + "'.", 211);
        }
        String string2 = ISO8601Parser.parseISO8601Day(string.substring(3), gregorianCalendar);
        if (string2 == null) {
            return gregorianCalendar;
        }
        String string3 = ISO8601Parser.parseISO8601Timezone(string2, gregorianCalendar);
        if (string3 != null) {
            throw new DatatypeParseException("Expecting end of lexical string, not '" + string3 + "'.", 307);
        }
        return gregorianCalendar;
    }

    private static String parseISO8601Day(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        int n;
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-+TZ", true);
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Illegal value for DD: '" + string2 + "'.", 212);
        }
        if (n > 31 || n < 0) {
            throw new DatatypeParseException("Illegal value for DD (>31): " + n + ".", 402);
        }
        if (gregorianCalendar.isSet(1)) {
            if (!ISO8601Parser.verifyDay(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, n)) {
                throw new DatatypeParseException("Illegal value for DD : " + n + " (YYYY = " + gregorianCalendar.get(1) + " MM = " + (gregorianCalendar.get(2) + 1) + ").", 412);
            }
        } else if (gregorianCalendar.isSet(2) && !ISO8601Parser.verifyDay(gregorianCalendar.get(2) + 1, n)) {
            throw new DatatypeParseException("Illegal value for DD : " + n + " (MM = " + (gregorianCalendar.get(2) + 1) + ").", 413);
        }
        gregorianCalendar.set(5, n);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return stringTokenizer.nextToken(NO_TOKEN);
    }

    public static GregorianCalendar parseISO8601Time(String string) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
        gregorianCalendar.clear();
        String string2 = ISO8601Parser.parseISO8601Time(string, gregorianCalendar);
        if (string2 != null) {
            ISO8601Parser.parseISO8601Timezone(string2, gregorianCalendar);
        }
        return gregorianCalendar;
    }

    private static String parseISO8601Time(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        int n;
        int n2;
        int n3;
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-:.Z+", true);
        boolean bl = false;
        String string2 = stringTokenizer.nextToken();
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Illegal value for hh '" + string2 + "'.", 213);
        }
        if (n3 > 24 || n3 < 0) {
            throw new DatatypeParseException("Illegal value for hh (>24) " + n3 + ".", 403);
        }
        if (n3 == 24) {
            bl = true;
        }
        gregorianCalendar.set(11, n3);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting ':mm:ss'.", 104);
        }
        string2 = stringTokenizer.nextToken();
        if (!string2.equals(":")) {
            throw new DatatypeParseException("Expecting token ':' not '" + string2 + "'.", 214);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting 'mm:ss'.", 105);
        }
        string2 = stringTokenizer.nextToken();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Illegal value for mm: '" + string2 + "'.", 215);
        }
        if (n2 > 60 || n2 < 0) {
            throw new DatatypeParseException("Illegal value for mm (>60): " + n2 + ".", 404);
        }
        if (bl && n2 != 0) {
            throw new DatatypeParseException("Illegal value for mm (>0): " + n2 + ".", 405);
        }
        gregorianCalendar.set(12, n2);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting ':ss'.", 106);
        }
        string2 = stringTokenizer.nextToken();
        if (!string2.equals(":")) {
            throw new DatatypeParseException("Expecting token ':' not '" + string2 + "'.", 216);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DatatypeParseException("Premature end of lexical string, expecting 'ss'.", 107);
        }
        string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeParseException("Illegal value for ss: '" + string2 + "'.", 217);
        }
        if (n > 60 || n < 0) {
            throw new DatatypeParseException("Illegal value for ss (>60): " + n + ".", 406);
        }
        if (bl && n != 0) {
            throw new DatatypeParseException("Illegal value for ss (>0): " + n + ".", 407);
        }
        gregorianCalendar.set(13, n);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string2 = stringTokenizer.nextToken();
        if (string2.equals(".")) {
            Double d;
            string2 = stringTokenizer.nextToken();
            try {
                d = Double.parseDouble("." + string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DatatypeParseException("Illegal value for ss: '" + string2 + "'.", 218);
            }
            int n4 = (int)(d * 1000.0);
            if (bl && n4 != 0) {
                throw new DatatypeParseException("Illegal value for ms (>0): " + n4 + ".", 408);
            }
            gregorianCalendar.set(14, n4);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            } else {
                return null;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            return string2 + stringTokenizer.nextToken(NO_TOKEN);
        }
        return string2;
    }

    private static String parseISO8601Timezone(String string, GregorianCalendar gregorianCalendar) throws DatatypeParseException {
        if (string == null || string.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-:.Z+", true);
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals("Z")) {
            int n;
            int n2;
            int n3 = 0;
            if (string2.equals("+")) {
                n3 = 1;
            } else if (string2.equals("-")) {
                n3 = -1;
            } else {
                throw new DatatypeParseException("Excepting token '+' or '-' for timezone, not '" + string2 + "'.", 219);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'hh:mm' for TZ.", 108);
            }
            string2 = stringTokenizer.nextToken();
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DatatypeParseException("Illegal value for TZ hh: '" + string2 + "'.", 220);
            }
            if (n2 > 14) {
                throw new DatatypeParseException("Illegal value for TZ hh (>14): " + n2 + ".", 409);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting ':mm' for TZ.", 109);
            }
            string2 = stringTokenizer.nextToken();
            if (!string2.equals(":")) {
                throw new DatatypeParseException("Expecting token ':' not '" + string2 + "'.", 221);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DatatypeParseException("Premature end of lexical string, expecting 'mm' for TZ", 110);
            }
            string2 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DatatypeParseException("Illegal value for TZ mm: '" + string2 + "'.", 222);
            }
            if (n > 60 || n < 0) {
                throw new DatatypeParseException("Illegal value for TZ mm (>60): " + n + ".", 410);
            }
            if (n2 == 14 && n != 0) {
                throw new DatatypeParseException("Illegal value for TZ mm (>0,hh=14): " + n + ".", 411);
            }
            int n4 = n3 * (n2 * 1000 * 3600 + n * 1000 * 60);
            gregorianCalendar.set(15, n4);
        } else {
            gregorianCalendar.set(15, 0);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return stringTokenizer.nextToken(NO_TOKEN);
    }

    public static String getCanonicalRepresentation(GregorianCalendar gregorianCalendar, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && !bl2 && bl3) {
            throw new IllegalArgumentException("Must set MM if YY and DD are set");
        }
        if ((bl != bl2 || bl != bl3) && bl4) {
            throw new IllegalArgumentException("If set time, must set or unset all YY MM DD");
        }
        if (bl4) {
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("Etc/UTC"));
            gregorianCalendar2.setTimeInMillis(gregorianCalendar.getTimeInMillis());
            gregorianCalendar = gregorianCalendar2;
        }
        if (bl) {
            int n = gregorianCalendar.get(1);
            if (gregorianCalendar.get(0) == 0) {
                stringBuffer.append("-" + ISO8601Parser.leadZeros(n, 4));
            } else if (n > 9999) {
                stringBuffer.append("+" + n);
            } else {
                stringBuffer.append(ISO8601Parser.leadZeros(n, 4));
            }
            if (bl2) {
                stringBuffer.append("-");
            }
        }
        if (bl2) {
            if (!bl) {
                stringBuffer.append("--");
            }
            stringBuffer.append(ISO8601Parser.leadZeros(gregorianCalendar.get(2) + 1, 2));
            if (bl3) {
                stringBuffer.append("-");
            } else {
                stringBuffer.append("--");
            }
        }
        if (bl3) {
            if (!bl2) {
                stringBuffer.append("---");
            }
            stringBuffer.append(ISO8601Parser.leadZeros(gregorianCalendar.get(5), 2));
            if (bl4) {
                stringBuffer.append("T");
            }
        }
        if (bl4) {
            stringBuffer.append(ISO8601Parser.leadZeros(gregorianCalendar.get(11), 2) + ":");
            stringBuffer.append(ISO8601Parser.leadZeros(gregorianCalendar.get(12), 2) + ":");
            stringBuffer.append(ISO8601Parser.leadZeros(gregorianCalendar.get(13), 2));
            int n = gregorianCalendar.get(14);
            if (n != 0) {
                stringBuffer.append(XSDTime.removeTrailingZeros(Double.toString((double)n / 1000.0).substring(1)));
            }
        }
        if (bl5 && bl4) {
            stringBuffer.append("Z");
        } else if (bl5) {
            int n = gregorianCalendar.get(15);
            if (n == 0) {
                stringBuffer.append("Z");
            } else {
                stringBuffer.append(ISO8601Parser.getHoursMinutes(n));
            }
        }
        return stringBuffer.toString();
    }

    public static String getHoursMinutes(int n) {
        int n2 = 1;
        if (n < 0) {
            n2 = -1;
            n *= -1;
        }
        int n3 = n / 60000;
        int n4 = n3 / 60;
        n3 %= 60;
        if (n2 == -1) {
            return "-" + ISO8601Parser.leadZeros(n4, 2) + ":" + ISO8601Parser.leadZeros(n3, 2);
        }
        return "+" + ISO8601Parser.leadZeros(n4, 2) + ":" + ISO8601Parser.leadZeros(n3, 2);
    }

    public static String leadZeros(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static String removeTrailingZeros(String string) {
        while (string.endsWith("0")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        GregorianCalendar gregorianCalendar = ISO8601Parser.parseISO8601Date("1242-04-14");
        System.err.println("1242-04-14");
        System.err.println(gregorianCalendar.get(0));
        System.err.println(gregorianCalendar.get(1));
        System.err.println(gregorianCalendar.get(2));
        System.err.println(gregorianCalendar.get(5));
        gregorianCalendar = ISO8601Parser.parseISO8601Time("23:34:45.001Z");
        System.err.println("23:34:45.001Z");
        System.err.println(gregorianCalendar.get(11));
        System.err.println(gregorianCalendar.get(12));
        System.err.println(gregorianCalendar.get(13));
        System.err.println(gregorianCalendar.get(14));
        System.err.println(gregorianCalendar.get(15));
        gregorianCalendar = ISO8601Parser.parseISO8601DateTime("1242-04-14T23:34:45.2015+13:30");
        System.err.println("1242-04-14T23:34:45.2015+14:30");
        System.err.println(gregorianCalendar.get(0));
        System.err.println(gregorianCalendar.get(1));
        System.err.println(gregorianCalendar.get(2));
        System.err.println(gregorianCalendar.get(5));
        System.err.println(gregorianCalendar.get(11));
        System.err.println(gregorianCalendar.get(12));
        System.err.println(gregorianCalendar.get(13));
        System.err.println(gregorianCalendar.get(14));
        System.err.println(gregorianCalendar.get(15));
        System.err.println(ISO8601Parser.verifyDay(100, 3, 32));
        System.err.println(ISO8601Parser.verifyDay(100, 3, 31));
        System.err.println(ISO8601Parser.verifyDay(100, 4, 31));
        System.err.println(ISO8601Parser.verifyDay(104, 2, 29));
        System.err.println(ISO8601Parser.verifyDay(100, 2, 29));
        System.err.println(ISO8601Parser.verifyDay(100, 3, 29));
        System.err.println(ISO8601Parser.verifyDay(100, 4, 29));
        System.err.println(ISO8601Parser.verifyDay(104, 5, 31));
    }

    public static boolean verifyDay(int n, int n2, int n3) {
        if (!ISO8601Parser.verifyDay(n2, n3)) {
            return false;
        }
        return n3 != 29 || n2 != 2 || n % 400 == 0 || n % 4 == 0 && n % 100 != 0;
    }

    public static boolean verifyDay(int n, int n2) {
        if (!ISO8601Parser.verifyDay(n2)) {
            return false;
        }
        return !(n2 == 31 ? n != 1 && n != 3 && n != 5 && n != 7 && n != 8 && n != 10 && n != 12 : n2 == 30 && n == 2);
    }

    public static boolean verifyDay(int n) {
        return n <= 31;
    }
}

