/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.binary;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

public class XSDBase64Binary
extends Datatype<String> {
    public static final Resource DT = XSD.BASE64BINARY;
    private String _h;
    public static final String REGEX = "((([A-Za-z0-9+/] ?){4})*(([A-Za-z0-9+/] ?){3}[A-Za-z0-9+/]|([A-Za-z0-9+/] ?){2}[AEIMQUYcgkosw048] ?=|[A-Za-z0-9+/] ?[AQgw] ?= ?=))?";

    public XSDBase64Binary(String string) throws DatatypeParseException {
        if (!Pattern.matches(REGEX, string)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex ((([A-Za-z0-9+/] ?){4})*(([A-Za-z0-9+/] ?){3}[A-Za-z0-9+/]|([A-Za-z0-9+/] ?){2}[AEIMQUYcgkosw048] ?=|[A-Za-z0-9+/] ?[AQgw] ?= ?=))?.", string, DT, 2);
        }
        this._h = string;
    }

    @Override
    public String getValue() {
        return this._h;
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._h;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        XSDBase64Binary xSDBase64Binary = new XSDBase64Binary("098abzxcbvks/ajg+r--cDF087123D");
        System.err.println(xSDBase64Binary.getCanonicalRepresentation());
    }
}

