/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt;

import java.util.HashMap;
import java.util.TreeSet;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeFactory;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.UnsupportedDatatypeException;
import org.semanticweb.yars.nx.namespace.XSD;
import org.semanticweb.yars.nx.parser.NxParser;

public class XSDDatatypeMap {
    public static final HashMap<Resource, DatatypeElement> MAP = new HashMap();

    public static boolean isSubtype(Resource resource, Resource resource2) throws UnsupportedDatatypeException {
        DatatypeElement datatypeElement = MAP.get(resource);
        DatatypeElement datatypeElement2 = MAP.get(resource2);
        if (datatypeElement == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + resource);
        }
        if (datatypeElement2 == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + resource);
        }
        return DatatypeElement.isSubtype(datatypeElement, datatypeElement2);
    }

    public static Resource getPrimitive(Resource resource) {
        DatatypeElement datatypeElement = MAP.get(resource);
        if (datatypeElement == null) {
            return resource;
        }
        return datatypeElement.getPrimitive().getURI();
    }

    public static Literal getCanonicalLiteral(Literal literal) throws DatatypeParseException {
        if (literal.getDatatype() != null && Datatype.isSupportedStandardDatatype(literal.getDatatype())) {
            Resource resource = XSDDatatypeMap.getPrimitive(literal.getDatatype());
            if (resource == null) {
                return literal;
            }
            Datatype<? extends Object> datatype = DatatypeFactory.getDatatype(literal.getUnescapedData(), resource);
            if (datatype == null) {
                return literal;
            }
            String string = datatype.getCanonicalRepresentation();
            if (!string.equals(literal.getUnescapedData()) || !resource.equals(literal.getDatatype())) {
                return new Literal(NxParser.escapeForNx(string), resource);
            }
        }
        return literal;
    }

    public static boolean areDisjoint(Resource resource, Resource resource2) throws UnsupportedDatatypeException {
        if (resource.equals(resource2)) {
            return false;
        }
        if (resource == null && resource2.equals(XSD.STRING)) {
            return false;
        }
        if (resource2 == null && resource.equals(XSD.STRING)) {
            return false;
        }
        DatatypeElement datatypeElement = MAP.get(resource);
        DatatypeElement datatypeElement2 = MAP.get(resource2);
        if (datatypeElement == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + resource);
        }
        if (datatypeElement2 == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + resource2);
        }
        return DatatypeElement.areDisjoint(datatypeElement, datatypeElement2);
    }

    public static void main(String[] stringArray) throws UnsupportedDatatypeException {
        System.err.println(XSDDatatypeMap.areDisjoint(XSD.BOOLEAN, new Resource("http://www.w3.org/2001/XMLSchema#boolean")));
    }

    static {
        DatatypeElement datatypeElement = new DatatypeElement(XSD.ANYURI, null);
        MAP.put(XSD.ANYURI, datatypeElement);
        DatatypeElement datatypeElement2 = new DatatypeElement(XSD.BASE64BINARY, null);
        MAP.put(XSD.BASE64BINARY, datatypeElement2);
        DatatypeElement datatypeElement3 = new DatatypeElement(XSD.BOOLEAN, null);
        MAP.put(XSD.BOOLEAN, datatypeElement3);
        DatatypeElement datatypeElement4 = new DatatypeElement(XSD.DATE, null);
        MAP.put(XSD.DATE, datatypeElement4);
        DatatypeElement datatypeElement5 = new DatatypeElement(XSD.DATETIME, null);
        MAP.put(XSD.DATETIME, datatypeElement5);
        DatatypeElement datatypeElement6 = new DatatypeElement(XSD.DATETIMESTAMP, datatypeElement5);
        MAP.put(XSD.DATETIMESTAMP, datatypeElement6);
        datatypeElement5.addSubtype(datatypeElement6);
        DatatypeElement datatypeElement7 = new DatatypeElement(XSD.DECIMAL, null);
        MAP.put(XSD.DECIMAL, datatypeElement7);
        DatatypeElement datatypeElement8 = new DatatypeElement(XSD.INTEGER, datatypeElement7);
        MAP.put(XSD.INTEGER, datatypeElement8);
        datatypeElement7.addSubtype(datatypeElement8);
        DatatypeElement datatypeElement9 = new DatatypeElement(XSD.LONG, datatypeElement7);
        MAP.put(XSD.LONG, datatypeElement9);
        datatypeElement8.addSubtype(datatypeElement9);
        DatatypeElement datatypeElement10 = new DatatypeElement(XSD.INT, datatypeElement7);
        MAP.put(XSD.INT, datatypeElement10);
        datatypeElement9.addSubtype(datatypeElement10);
        DatatypeElement datatypeElement11 = new DatatypeElement(XSD.SHORT, datatypeElement7);
        MAP.put(XSD.SHORT, datatypeElement11);
        datatypeElement10.addSubtype(datatypeElement11);
        DatatypeElement datatypeElement12 = new DatatypeElement(XSD.BYTE, datatypeElement7);
        MAP.put(XSD.BYTE, datatypeElement12);
        datatypeElement11.addSubtype(datatypeElement12);
        DatatypeElement datatypeElement13 = new DatatypeElement(XSD.NONNEGATIVEINTEGER, datatypeElement7);
        MAP.put(XSD.NONNEGATIVEINTEGER, datatypeElement13);
        datatypeElement8.addSubtype(datatypeElement13);
        DatatypeElement datatypeElement14 = new DatatypeElement(XSD.POSITIVEINTEGER, datatypeElement7);
        MAP.put(XSD.POSITIVEINTEGER, datatypeElement14);
        datatypeElement13.addSubtype(datatypeElement14);
        DatatypeElement datatypeElement15 = new DatatypeElement(XSD.UNSIGNEDLONG, datatypeElement7);
        MAP.put(XSD.UNSIGNEDLONG, datatypeElement15);
        datatypeElement13.addSubtype(datatypeElement15);
        DatatypeElement datatypeElement16 = new DatatypeElement(XSD.UNSIGNEDINT, datatypeElement7);
        MAP.put(XSD.UNSIGNEDINT, datatypeElement16);
        datatypeElement15.addSubtype(datatypeElement16);
        DatatypeElement datatypeElement17 = new DatatypeElement(XSD.UNSIGNEDSHORT, datatypeElement7);
        MAP.put(XSD.UNSIGNEDSHORT, datatypeElement17);
        datatypeElement16.addSubtype(datatypeElement17);
        DatatypeElement datatypeElement18 = new DatatypeElement(XSD.UNSIGNEDBYTE, datatypeElement7);
        MAP.put(XSD.UNSIGNEDBYTE, datatypeElement18);
        datatypeElement17.addSubtype(datatypeElement18);
        DatatypeElement datatypeElement19 = new DatatypeElement(XSD.NONPOSITIVEINTEGER, datatypeElement7);
        MAP.put(XSD.NONPOSITIVEINTEGER, datatypeElement19);
        datatypeElement8.addSubtype(datatypeElement19);
        DatatypeElement datatypeElement20 = new DatatypeElement(XSD.NEGATIVEINTEGER, datatypeElement7);
        MAP.put(XSD.NEGATIVEINTEGER, datatypeElement20);
        datatypeElement19.addSubtype(datatypeElement20);
        DatatypeElement datatypeElement21 = new DatatypeElement(XSD.FLOAT, null);
        MAP.put(XSD.FLOAT, datatypeElement21);
        DatatypeElement datatypeElement22 = new DatatypeElement(XSD.GDAY, null);
        MAP.put(XSD.GDAY, datatypeElement22);
        DatatypeElement datatypeElement23 = new DatatypeElement(XSD.GMONTH, null);
        MAP.put(XSD.GMONTH, datatypeElement23);
        DatatypeElement datatypeElement24 = new DatatypeElement(XSD.GMONTHDAY, null);
        MAP.put(XSD.GMONTHDAY, datatypeElement24);
        DatatypeElement datatypeElement25 = new DatatypeElement(XSD.GYEAR, null);
        MAP.put(XSD.GYEAR, datatypeElement25);
        DatatypeElement datatypeElement26 = new DatatypeElement(XSD.GYEARMONTH, null);
        MAP.put(XSD.GYEARMONTH, datatypeElement26);
        DatatypeElement datatypeElement27 = new DatatypeElement(XSD.HEXBINARY, null);
        MAP.put(XSD.HEXBINARY, datatypeElement27);
        DatatypeElement datatypeElement28 = new DatatypeElement(XSD.STRING, null);
        MAP.put(XSD.STRING, datatypeElement28);
        DatatypeElement datatypeElement29 = new DatatypeElement(XSD.NORMALIZEDSTRING, datatypeElement28);
        MAP.put(XSD.NORMALIZEDSTRING, datatypeElement28);
        datatypeElement28.addSubtype(datatypeElement29);
        DatatypeElement datatypeElement30 = new DatatypeElement(XSD.TOKEN, datatypeElement28);
        MAP.put(XSD.TOKEN, datatypeElement30);
        datatypeElement29.addSubtype(datatypeElement30);
        DatatypeElement datatypeElement31 = new DatatypeElement(XSD.LANGUAGE, datatypeElement28);
        MAP.put(XSD.LANGUAGE, datatypeElement31);
        datatypeElement30.addSubtype(datatypeElement31);
        DatatypeElement datatypeElement32 = new DatatypeElement(XSD.NAME, datatypeElement28);
        MAP.put(XSD.NAME, datatypeElement32);
        datatypeElement30.addSubtype(datatypeElement32);
        DatatypeElement datatypeElement33 = new DatatypeElement(XSD.NCNAME, datatypeElement28);
        MAP.put(XSD.NCNAME, datatypeElement33);
        datatypeElement32.addSubtype(datatypeElement33);
        DatatypeElement datatypeElement34 = new DatatypeElement(XSD.NMTOKEN, datatypeElement28);
        MAP.put(XSD.NMTOKEN, datatypeElement34);
        datatypeElement30.addSubtype(datatypeElement34);
        DatatypeElement datatypeElement35 = new DatatypeElement(XSD.TIME, null);
        MAP.put(XSD.TIME, datatypeElement35);
    }

    public static class DatatypeElement
    implements Comparable<DatatypeElement> {
        private DatatypeElement _primitive;
        private Resource _uri;
        private TreeSet<DatatypeElement> _subtypes = null;

        public DatatypeElement(Resource resource, DatatypeElement datatypeElement) {
            this._uri = resource;
            this._primitive = datatypeElement;
        }

        public Resource getURI() {
            return this._uri;
        }

        public void addSubtype(DatatypeElement ... datatypeElementArray) {
            if (this._subtypes == null) {
                this._subtypes = new TreeSet();
            }
            for (DatatypeElement datatypeElement : datatypeElementArray) {
                this._subtypes.add(datatypeElement);
            }
        }

        @Override
        public int compareTo(DatatypeElement datatypeElement) {
            return this._uri.compareTo(datatypeElement._uri);
        }

        public boolean isPrimitive() {
            return this._primitive == null;
        }

        public DatatypeElement getPrimitive() {
            if (this.isPrimitive()) {
                return this;
            }
            return this._primitive;
        }

        public TreeSet<DatatypeElement> getSubtypes() {
            return this._subtypes;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DatatypeElement) {
                return this.equals((DatatypeElement)object);
            }
            return false;
        }

        public boolean equals(DatatypeElement datatypeElement) {
            if (datatypeElement == this) {
                return true;
            }
            return this._uri.equals(datatypeElement._uri);
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean isSubtype(DatatypeElement datatypeElement) {
            return DatatypeElement.isSubtype(this, datatypeElement);
        }

        public TreeSet<DatatypeElement> getAllSubtypes() {
            return DatatypeElement.getAllSubtypes(this);
        }

        public static boolean isSubtype(DatatypeElement datatypeElement, DatatypeElement datatypeElement2) {
            TreeSet<DatatypeElement> treeSet = datatypeElement.getAllSubtypes();
            return treeSet.contains(datatypeElement2);
        }

        public static TreeSet<DatatypeElement> getAllSubtypes(DatatypeElement datatypeElement) {
            TreeSet<DatatypeElement> treeSet = new TreeSet<DatatypeElement>();
            treeSet.add(datatypeElement);
            DatatypeElement.getAllSubtypes(datatypeElement, treeSet);
            return treeSet;
        }

        private static void getAllSubtypes(DatatypeElement datatypeElement, TreeSet<DatatypeElement> treeSet) {
            if (datatypeElement._subtypes == null) {
                return;
            }
            for (DatatypeElement datatypeElement2 : datatypeElement._subtypes) {
                treeSet.add(datatypeElement2);
                DatatypeElement.getAllSubtypes(datatypeElement2, treeSet);
            }
        }

        public static boolean areDisjoint(DatatypeElement datatypeElement, DatatypeElement datatypeElement2) {
            return !datatypeElement.getPrimitive().equals(datatypeElement2.getPrimitive());
        }
    }
}

