/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt;

import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.binary.XSDBase64Binary;
import org.semanticweb.yars.nx.dt.binary.XSDHexBinary;
import org.semanticweb.yars.nx.dt.bool.XSDBoolean;
import org.semanticweb.yars.nx.dt.datetime.XSDDate;
import org.semanticweb.yars.nx.dt.datetime.XSDDateTime;
import org.semanticweb.yars.nx.dt.datetime.XSDDateTimeStamp;
import org.semanticweb.yars.nx.dt.datetime.XSDGDay;
import org.semanticweb.yars.nx.dt.datetime.XSDGMonth;
import org.semanticweb.yars.nx.dt.datetime.XSDGMonthDay;
import org.semanticweb.yars.nx.dt.datetime.XSDGYear;
import org.semanticweb.yars.nx.dt.datetime.XSDGYearMonth;
import org.semanticweb.yars.nx.dt.datetime.XSDTime;
import org.semanticweb.yars.nx.dt.numeric.XSDByte;
import org.semanticweb.yars.nx.dt.numeric.XSDDecimal;
import org.semanticweb.yars.nx.dt.numeric.XSDDouble;
import org.semanticweb.yars.nx.dt.numeric.XSDFloat;
import org.semanticweb.yars.nx.dt.numeric.XSDInt;
import org.semanticweb.yars.nx.dt.numeric.XSDInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDLong;
import org.semanticweb.yars.nx.dt.numeric.XSDNegativeInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDNonNegativeInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDNonPositiveInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDPositiveInteger;
import org.semanticweb.yars.nx.dt.numeric.XSDShort;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedByte;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedInt;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedLong;
import org.semanticweb.yars.nx.dt.numeric.XSDUnsignedShort;
import org.semanticweb.yars.nx.dt.string.XSDLanguage;
import org.semanticweb.yars.nx.dt.string.XSDNCName;
import org.semanticweb.yars.nx.dt.string.XSDNMToken;
import org.semanticweb.yars.nx.dt.string.XSDName;
import org.semanticweb.yars.nx.dt.string.XSDNormalisedString;
import org.semanticweb.yars.nx.dt.string.XSDString;
import org.semanticweb.yars.nx.dt.string.XSDToken;
import org.semanticweb.yars.nx.dt.uri.XSDAnyURI;
import org.semanticweb.yars.nx.dt.xml.RDFXMLLiteral;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.namespace.XSD;

public class DatatypeFactory {
    public static Datatype<? extends Object> getDatatype(Literal literal) throws DatatypeParseException {
        return DatatypeFactory.getDatatype(literal.getUnescapedData(), literal.getDatatype());
    }

    public static Datatype<? extends Object> getDatatype(String string, Resource resource) throws DatatypeParseException {
        if (resource == null || string == null) {
            return null;
        }
        if (resource.toString().startsWith("http://www.w3.org/2001/XMLSchema#")) {
            if (resource.equals(XSD.STRING)) {
                return new XSDString(string);
            }
            if (resource.equals(XSD.BOOLEAN)) {
                return new XSDBoolean(string);
            }
            if (resource.equals(XSD.INTEGER)) {
                return new XSDInteger(string);
            }
            if (resource.equals(XSD.DATETIME)) {
                return new XSDDateTime(string);
            }
            if (resource.equals(XSD.DATETIMESTAMP)) {
                return new XSDDateTimeStamp(string);
            }
            if (resource.equals(XSD.DATE)) {
                return new XSDDate(string);
            }
            if (resource.equals(XSD.TIME)) {
                return new XSDTime(string);
            }
            if (resource.equals(XSD.INT)) {
                return new XSDInt(string);
            }
            if (resource.equals(XSD.LONG)) {
                return new XSDLong(string);
            }
            if (resource.equals(XSD.SHORT)) {
                return new XSDShort(string);
            }
            if (resource.equals(XSD.BYTE)) {
                return new XSDByte(string);
            }
            if (resource.equals(XSD.DECIMAL)) {
                return new XSDDecimal(string);
            }
            if (resource.equals(XSD.FLOAT)) {
                return new XSDFloat(string);
            }
            if (resource.equals(XSD.DOUBLE)) {
                return new XSDDouble(string);
            }
            if (resource.equals(XSD.GYEARMONTH)) {
                return new XSDGYearMonth(string);
            }
            if (resource.equals(XSD.GYEAR)) {
                return new XSDGYear(string);
            }
            if (resource.equals(XSD.GMONTHDAY)) {
                return new XSDGMonthDay(string);
            }
            if (resource.equals(XSD.GMONTH)) {
                return new XSDGMonth(string);
            }
            if (resource.equals(XSD.GDAY)) {
                return new XSDGDay(string);
            }
            if (resource.equals(XSD.HEXBINARY)) {
                return new XSDHexBinary(string);
            }
            if (resource.equals(XSD.BASE64BINARY)) {
                return new XSDBase64Binary(string);
            }
            if (resource.equals(XSD.TOKEN)) {
                return new XSDToken(string);
            }
            if (resource.equals(XSD.NMTOKEN)) {
                return new XSDNMToken(string);
            }
            if (resource.equals(XSD.NAME)) {
                return new XSDName(string);
            }
            if (resource.equals(XSD.NCNAME)) {
                return new XSDNCName(string);
            }
            if (resource.equals(XSD.NONNEGATIVEINTEGER)) {
                return new XSDNonNegativeInteger(string);
            }
            if (resource.equals(XSD.POSITIVEINTEGER)) {
                return new XSDPositiveInteger(string);
            }
            if (resource.equals(XSD.NONPOSITIVEINTEGER)) {
                return new XSDNonPositiveInteger(string);
            }
            if (resource.equals(XSD.NEGATIVEINTEGER)) {
                return new XSDNegativeInteger(string);
            }
            if (resource.equals(XSD.NORMALIZEDSTRING)) {
                return new XSDNormalisedString(string);
            }
            if (resource.equals(XSD.ANYURI)) {
                return new XSDAnyURI(string);
            }
            if (resource.equals(XSD.LANGUAGE)) {
                return new XSDLanguage(string);
            }
            if (resource.equals(XSD.UNSIGNEDLONG)) {
                return new XSDUnsignedLong(string);
            }
            if (resource.equals(XSD.UNSIGNEDINT)) {
                return new XSDUnsignedInt(string);
            }
            if (resource.equals(XSD.UNSIGNEDSHORT)) {
                return new XSDUnsignedShort(string);
            }
            if (resource.equals(XSD.UNSIGNEDBYTE)) {
                return new XSDUnsignedByte(string);
            }
        } else if (resource.equals(RDF.XMLLITERAL)) {
            return new RDFXMLLiteral(string);
        }
        return null;
    }

    public static void main(String[] stringArray) throws DatatypeParseException {
        System.err.println(DatatypeFactory.getDatatype("2005-03-04", XSD.DATETIME));
    }
}

