/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt;

import java.util.TreeSet;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.namespace.XSD;

public abstract class Datatype<E> {
    public static final Resource[] SUPPORTED_STD_DTS = new Resource[]{XSD.STRING, XSD.BOOLEAN, XSD.INTEGER, XSD.DATETIME, XSD.DATE, XSD.DATETIMESTAMP, XSD.TIME, XSD.INT, XSD.LONG, XSD.SHORT, XSD.BYTE, XSD.DECIMAL, XSD.FLOAT, XSD.DOUBLE, XSD.GYEARMONTH, XSD.GYEAR, XSD.GMONTHDAY, XSD.GMONTH, XSD.GDAY, XSD.HEXBINARY, XSD.BASE64BINARY, XSD.TOKEN, XSD.NMTOKEN, XSD.NAME, XSD.NCNAME, XSD.NONNEGATIVEINTEGER, XSD.POSITIVEINTEGER, XSD.NONPOSITIVEINTEGER, XSD.NEGATIVEINTEGER, XSD.NORMALIZEDSTRING, XSD.ANYURI, XSD.LANGUAGE, XSD.UNSIGNEDLONG, XSD.UNSIGNEDINT, XSD.UNSIGNEDSHORT, XSD.UNSIGNEDBYTE, RDF.XMLLITERAL};
    public static final TreeSet<Resource> SUPPORTED_STD_DTS_TS = new TreeSet();

    public abstract E getValue();

    public abstract String getCanonicalRepresentation();

    public static boolean isSupportedStandardDatatype(Resource resource) {
        return SUPPORTED_STD_DTS_TS.contains(resource);
    }

    public static boolean isSupportedStandardDatatype(Node node) {
        if (node instanceof Resource) {
            return Datatype.isSupportedStandardDatatype((Resource)node);
        }
        return false;
    }

    static {
        for (Resource resource : SUPPORTED_STD_DTS) {
            SUPPORTED_STD_DTS_TS.add(resource);
        }
    }
}

