/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Random;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;

public class Split {
    static transient Logger _log = Logger.getLogger(Split.class.getName());

    public static void main(String[] stringArray) throws ParseException, IOException {
        Object object;
        int n;
        Options options = Main.getStandardOptions();
        options.getOption("o").setDescription("output file mask; should contain a '%' which will be replaced by file number; directory should exist");
        Option option = new Option("e", "elements to hash for split, e.g. 01 to hash on first and second element; default no hashing, random split");
        option.setArgs(1);
        option.setRequired(false);
        options.addOption(option);
        Option option2 = new Option("n", "number of output files to split");
        option2.setArgs(1);
        option2.setRequired(true);
        options.addOption(option2);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        int n2 = Integer.parseInt(commandLine.getOptionValue("n"));
        if (n2 < 2) {
            System.err.println("***ERROR: n should be an integer >2");
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = Main.getMainInputStream(commandLine);
        NxParser nxParser = new NxParser(inputStream);
        OutputStream[] outputStreamArray = new OutputStream[n2];
        BufferedWriter[] bufferedWriterArray = new BufferedWriter[n2];
        CallbackNxBufferedWriter[] callbackNxBufferedWriterArray = new CallbackNxBufferedWriter[n2];
        String string = commandLine.getOptionValue("o");
        if (!string.contains("%")) {
            System.err.println("***ERROR: o should contain at least one '%' character");
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        for (n = 0; n < n2; ++n) {
            object = string.replaceAll("%", Integer.toString(n));
            Main.mkdirsForFile((String)object);
            outputStreamArray[n] = new FileOutputStream((String)object);
            if (commandLine.hasOption("ogz")) {
                outputStreamArray[n] = new GZIPOutputStream(outputStreamArray[n]);
            }
            bufferedWriterArray[n] = new BufferedWriter(new OutputStreamWriter(outputStreamArray[n]));
            callbackNxBufferedWriterArray[n] = new CallbackNxBufferedWriter(bufferedWriterArray[n]);
        }
        n = Main.getTicks(commandLine);
        object = null;
        Random random = null;
        if (commandLine.hasOption("e")) {
            object = Main.getMask(commandLine.getOptionValue("e"));
        } else {
            random = new Random();
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        while (nxParser.hasNext()) {
            Object[] objectArray = (Node[])nxParser.next();
            if (++n3 % n == 0) {
                _log.info("...read " + n3);
            }
            int n4 = -1;
            if (object != null) {
                int n5;
                Node[] nodeArray = new Node[((Object)object).length];
                for (n5 = 0; n5 < ((Object)object).length; ++n5) {
                    nodeArray[n5] = objectArray[object[n5]];
                }
                n5 = Nodes.hashCode(nodeArray);
                n5 = Math.abs(n5);
                n4 = n5 % n2;
            } else {
                n4 = random.nextInt(n2);
            }
            callbackNxBufferedWriterArray[n4].processStatement((Node[])objectArray);
            int n6 = n4;
            nArray[n6] = nArray[n6] + 1;
        }
        inputStream.close();
        for (BufferedWriter bufferedWriter : bufferedWriterArray) {
            bufferedWriter.close();
        }
        _log.info("...finished... read " + n3 + ".");
        for (int i = 0; i < n2; ++i) {
            _log.info("...file " + i + " written " + nArray[i]);
        }
        double d = Split.absAverageDeviation(nArray);
        _log.info("... absolute average deviation from mean " + d);
    }

    public static double absAverageDeviation(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        double d = (double)n / (double)nArray.length;
        double d2 = 0.0;
        for (int n3 : nArray) {
            d2 += Math.abs((double)n3 - d);
        }
        return d2 / (double)nArray.length;
    }
}

