/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.sort.SortIterator;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;
import org.semanticweb.yars.util.CheckSortedIterator;
import org.semanticweb.yars.util.SniffIterator;

public class Sort {
    static transient Logger _log = Logger.getLogger(Sort.class.getName());

    public static void main(String[] stringArray) throws ParseException, IOException {
        SortIterator sortIterator;
        Object object;
        Options options = Main.getStandardOptions();
        Option option = new Option("so", "sort order: e.g. 0123 for SPOC 3012 for CSPO (written order preserved)");
        option.setArgs(1);
        option.setRequired(false);
        options.addOption(option);
        Option option2 = new Option("no", "numeric order: e.g. 2 for objects of order SPOC/0123, 21 for objects and predicates (independent of sort order)");
        option2.setArgs(1);
        option2.setRequired(false);
        options.addOption(option2);
        Option option3 = new Option("ro", "reverse order: e.g. 2 for objects of order SPOC/0123, 21 for objects and predicates (independent of sort order)");
        option3.setArgs(1);
        option3.setRequired(false);
        options.addOption(option3);
        Option option4 = new Option("tmp", "tmp folder for batches");
        option4.setArgs(1);
        option4.setRequired(false);
        options.addOption(option4);
        Option option5 = new Option("ad", "allow duplicates");
        option5.setArgs(0);
        option5.setRequired(false);
        options.addOption(option5);
        Option option6 = new Option("b", "set batch size (default calculated based on magic numbers, tuple length and heap space)");
        option6.setArgs(1);
        option6.setRequired(false);
        options.addOption(option6);
        Option option7 = new Option("nbz", "no batch gzipping, takes more disk, less time (default gzipped)");
        option7.setArgs(0);
        option7.setRequired(false);
        options.addOption(option7);
        Option option8 = new Option("ab", "adaptive batching based on monitoring of heap-space (default static batches, experimental/not recommended)");
        option8.setArgs(0);
        option8.setRequired(false);
        options.addOption(option8);
        Option option9 = new Option("fw", "flyweight cache size for input iterator (default off, experimental/not recommended)");
        option9.setArgs(1);
        option9.setRequired(false);
        options.addOption(option9);
        Option option10 = new Option("v", "verify sort order (debug mode)");
        option10.setArgs(0);
        option10.setRequired(false);
        options.addOption(option10);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("b") && commandLine.hasOption("ab")) {
            System.err.println("***ERROR: Please set -b *OR* -ab.");
        }
        InputStream inputStream = Main.getMainInputStream(commandLine);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Main.getMainOutputStream(commandLine)));
        int n = Main.getTicks(commandLine);
        NxParser nxParser = new NxParser(inputStream);
        CallbackNxBufferedWriter callbackNxBufferedWriter = new CallbackNxBufferedWriter(bufferedWriter);
        NodeComparator.NodeComparatorArgs nodeComparatorArgs = new NodeComparator.NodeComparatorArgs();
        if (commandLine.hasOption("so")) {
            nodeComparatorArgs.setOrder(NodeComparator.NodeComparatorArgs.getIntegerMask(commandLine.getOptionValue("so")));
        }
        if (commandLine.hasOption("no")) {
            nodeComparatorArgs.setNumeric(NodeComparator.NodeComparatorArgs.getBooleanMask(commandLine.getOptionValue("no")));
        }
        if (commandLine.hasOption("ro")) {
            nodeComparatorArgs.setReverse(NodeComparator.NodeComparatorArgs.getBooleanMask(commandLine.getOptionValue("ro")));
        }
        if (commandLine.hasOption("ad")) {
            nodeComparatorArgs.setNoEquals(true);
            nodeComparatorArgs.setNoZero(true);
        }
        String string = null;
        if (commandLine.hasOption("tmp")) {
            string = commandLine.getOptionValue("tmp");
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                string = string + "/";
            }
            object = new File(string);
            ((File)object).mkdirs();
        }
        object = new SniffIterator(nxParser);
        NodeComparator nodeComparator = new NodeComparator(nodeComparatorArgs);
        SortIterator.SortArgs sortArgs = new SortIterator.SortArgs((Iterator<Node[]>)object, ((SniffIterator)object).nxLength());
        sortArgs.setTicks(n);
        sortArgs.setComparator(nodeComparator);
        sortArgs.setTmpDir(string);
        if (commandLine.hasOption("b")) {
            sortArgs.setLinesPerBatch(Integer.parseInt(commandLine.getOptionValue("b")));
        } else if (commandLine.hasOption("ab")) {
            sortArgs.setAdaptiveBatches();
        }
        if (commandLine.hasOption("fw")) {
            sortArgs.setFlyWeight(Integer.parseInt(commandLine.getOptionValue("fw")));
        }
        if (commandLine.hasOption("nbz")) {
            sortArgs.setGzipBatches(false);
        }
        Iterator<Node[]> iterator = sortIterator = new SortIterator(sortArgs);
        CheckSortedIterator checkSortedIterator = null;
        if (commandLine.hasOption("v")) {
            _log.info("Also verifying sort order...");
            checkSortedIterator = new CheckSortedIterator(sortIterator, nodeComparator);
            iterator = checkSortedIterator;
        }
        while (iterator.hasNext()) {
            callbackNxBufferedWriter.processStatement((Node[])iterator.next());
        }
        if (commandLine.hasOption("v")) {
            _log.info("Also verifying sort order...");
            iterator = new CheckSortedIterator(sortIterator, nodeComparator);
        }
        _log.info("Finished sort. Sorted " + sortIterator.count() + " with " + sortIterator.duplicates() + " duplicates.");
        inputStream.close();
        bufferedWriter.close();
        if (checkSortedIterator != null) {
            _log.info("Sort order okay? : " + checkSortedIterator.isOkay());
        }
    }
}

