/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.reorder.ReorderIterator;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;

public class Reorder {
    static transient Logger _log = Logger.getLogger(Reorder.class.getName());

    public static void main(String[] stringArray) throws IOException, ParseException {
        Option option = new Option("m", "where 0123 is an integer mask, out[0] = in[2], out[1] = in[3], out[2] = in[0], out[3] = in[1]\nexample: spoc => pocs, pocs => ocsp, ocsp => cspo, cspo => spoc 1230\nexample: pocs => spoc, spoc => cspo, cspo => ocsp, ocsp => pocs 3012\nexample: spoc => sopc 0213\nexample: spoc => cpso 3102");
        option.setArgs(1);
        option.setRequired(true);
        Options options = Main.getStandardOptions();
        options.addOption(option);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        int[] nArray = Reorder.getMask(commandLine.getOptionValue("m"));
        InputStream inputStream = Main.getMainInputStream(commandLine);
        OutputStream outputStream = Main.getMainOutputStream(commandLine);
        int n = Main.getTicks(commandLine);
        NxParser nxParser = new NxParser(inputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        CallbackNxBufferedWriter callbackNxBufferedWriter = new CallbackNxBufferedWriter(bufferedWriter);
        ReorderIterator reorderIterator = new ReorderIterator(nxParser, nArray, n);
        while (reorderIterator.hasNext()) {
            callbackNxBufferedWriter.processStatement(reorderIterator.next());
        }
        _log.info("Finished reorder. Reordered " + reorderIterator.count() + " statements.");
        inputStream.close();
        bufferedWriter.close();
    }

    public static int[] getMask(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(Character.toString(string.charAt(i)));
        }
        return nArray;
    }
}

