/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.nx.sort.MergeSortIterator;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;
import org.semanticweb.yars.util.CheckSortedIterator;

public class MergeSort {
    static transient Logger _log = Logger.getLogger(MergeSort.class.getName());
    public static final String DIR = ".";

    public static void main(String[] stringArray) throws ParseException, IOException {
        Options options = new Options();
        Main.addHelpOption(options);
        Main.addOutputOption(options, "o", "");
        Main.addTicksOption(options);
        Main.addInputsOption(options, "i", "");
        Option option = new Option("so", "sort order: e.g. 0123 for SPOC 3012 for CSPO (written order preserved)");
        option.setArgs(1);
        option.setRequired(true);
        options.addOption(option);
        Option option2 = new Option("no", "numeric order: e.g. 2 for objects of order SPOC/0123, 21 for objects and predicates (independent of sort order)");
        option2.setArgs(1);
        option2.setRequired(false);
        options.addOption(option2);
        Option option3 = new Option("ro", "reverse order: e.g. 2 for objects of order SPOC/0123, 21 for objects and predicates (independent of sort order)");
        option3.setArgs(1);
        option3.setRequired(false);
        options.addOption(option3);
        Option option4 = new Option("ad", "allow duplicates");
        option4.setArgs(0);
        option4.setRequired(false);
        options.addOption(option4);
        Option option5 = new Option("v", "verify ordered");
        option5.setRequired(false);
        options.addOption(option5);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        int n = Main.getTicks(commandLine);
        InputStream[] inputStreamArray = Main.getMainInputStreams(commandLine);
        Iterator[] iteratorArray = new Iterator[inputStreamArray.length];
        for (int i = 0; i < inputStreamArray.length; ++i) {
            iteratorArray[i] = new NxParser(inputStreamArray[i]);
        }
        _log.info("Opened " + iteratorArray.length + " files for merging");
        OutputStream outputStream = Main.getMainOutputStream(commandLine);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        CallbackNxBufferedWriter callbackNxBufferedWriter = new CallbackNxBufferedWriter(bufferedWriter);
        NodeComparator.NodeComparatorArgs nodeComparatorArgs = new NodeComparator.NodeComparatorArgs();
        if (commandLine.hasOption("so")) {
            nodeComparatorArgs.setOrder(NodeComparator.NodeComparatorArgs.getIntegerMask(commandLine.getOptionValue("so")));
        }
        if (commandLine.hasOption("no")) {
            nodeComparatorArgs.setNumeric(NodeComparator.NodeComparatorArgs.getBooleanMask(commandLine.getOptionValue("no")));
        }
        if (commandLine.hasOption("ro")) {
            nodeComparatorArgs.setReverse(NodeComparator.NodeComparatorArgs.getBooleanMask(commandLine.getOptionValue("ro")));
        }
        if (commandLine.hasOption("ad")) {
            nodeComparatorArgs.setNoEquals(true);
            nodeComparatorArgs.setNoZero(true);
        }
        MergeSortIterator.MergeSortArgs mergeSortArgs = new MergeSortIterator.MergeSortArgs(iteratorArray);
        NodeComparator nodeComparator = new NodeComparator(nodeComparatorArgs);
        mergeSortArgs.setComparator(nodeComparator);
        mergeSortArgs.setTicks(n);
        MergeSortIterator mergeSortIterator = new MergeSortIterator(mergeSortArgs);
        boolean bl = commandLine.hasOption("v");
        CheckSortedIterator checkSortedIterator = null;
        Iterator<Node[]> iterator = mergeSortIterator;
        if (bl) {
            checkSortedIterator = new CheckSortedIterator(mergeSortIterator, nodeComparator);
            iterator = checkSortedIterator;
        }
        while (iterator.hasNext()) {
            callbackNxBufferedWriter.processStatement((Node[])iterator.next());
            if (!bl || checkSortedIterator.isOkay()) continue;
            throw new RuntimeException(checkSortedIterator.getException());
        }
        _log.info("Finished sort. Sorted " + mergeSortIterator.count() + " with " + mergeSortIterator.duplicates() + " duplicates.");
        for (InputStream inputStream : inputStreamArray) {
            inputStream.close();
        }
        bufferedWriter.close();
    }

    static int[] getMask(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(Character.toString(string.charAt(i)));
        }
        return nArray;
    }
}

