/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Main {
    static transient Logger _log = Logger.getLogger(Main.class.getName());
    private static final String USAGE = "usage: org.semanticweb.yars.nx.cli.Main <utility> [options...]";
    private static final String PREFIX = "org.semanticweb.yars.nx.cli.";
    public static int TICKS = 10000000;
    public static final String DEFAULT_TMP_DIR = "./nxtmp/";
    private static String TMP_DIR;
    public static final String TEMP_PREFIX = "tmp";

    public static void main(String[] stringArray) {
        try {
            Serializable serializable;
            if (stringArray.length < 1) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append("where <utility> one of");
                ((StringBuffer)serializable).append("\n\tParse             Parse nx file");
                ((StringBuffer)serializable).append("\n\tClean             Normalise URIs and clean HTML from input");
                ((StringBuffer)serializable).append("\n\tClean             Normalise URIs and clean HTML from input");
                ((StringBuffer)serializable).append("\n\tCleanXML          Removes invalid character references in XML");
                ((StringBuffer)serializable).append("\n\tGetURIs           Get all URIs in an NX file");
                ((StringBuffer)serializable).append("\n\tBenchmark         Run benchmarks");
                ((StringBuffer)serializable).append("\n\tPickLabels        Pick unique labels");
                ((StringBuffer)serializable).append("\n\tParseRDFXML       Parse RDF/XML file");
                ((StringBuffer)serializable).append("\n\tReorder           Reorder some data");
                ((StringBuffer)serializable).append("\n\tSample            Random sampling");
                ((StringBuffer)serializable).append("\n\tSplit             Split a big file");
                ((StringBuffer)serializable).append("\n\tStats             Analyse the NQ file and print some nice stats");
                ((StringBuffer)serializable).append("\n\tSort              Sort some data");
                ((StringBuffer)serializable).append("\n\tMergeSort         Merge-sort pre-sorted files");
                _log.severe(USAGE);
                _log.severe(((StringBuffer)serializable).toString());
                System.exit(-1);
            }
            serializable = Class.forName(PREFIX + stringArray[0]);
            Method method = ((Class)serializable).getMethod("main", String[].class);
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            long l = System.currentTimeMillis();
            method.invoke(null, new Object[]{stringArray2});
            long l2 = System.currentTimeMillis();
            _log.info("time elapsed " + (l2 - l) + " ms");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Throwable throwable2 = throwable.getCause();
            throwable2.printStackTrace();
            _log.severe(USAGE);
            _log.severe(throwable.toString());
            System.exit(-1);
        }
    }

    public static String getRootTempDir() {
        return TMP_DIR;
    }

    public static void setRootTempDir(String string) {
        TMP_DIR = string;
    }

    public static String getTempSubDir() {
        return Main.getTempSubDir(TMP_DIR);
    }

    public static String getTempSubDir(String string) {
        String string2 = string + "/" + TEMP_PREFIX + new Random().nextInt() + "/";
        File file = new File(string2);
        if (file.mkdirs()) {
            file.deleteOnExit();
        }
        return string2;
    }

    public static InputStream[] getMainInputStreams(CommandLine commandLine) throws IOException {
        return Main.getInputStreams(commandLine, "i");
    }

    public static InputStream[] getInputStreams(CommandLine commandLine, String string) throws IOException {
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
        String[] stringArray = commandLine.getOptionValues(string);
        boolean bl = false;
        if (commandLine.hasOption(string + "gz")) {
            bl = true;
            _log.info("All '" + string + "' inputs are gzipped");
        }
        for (String string2 : stringArray) {
            File file = new File(string2);
            if (!file.exists()) {
                throw new IOException("Cannot find file " + string2);
            }
            if (file.isFile()) {
                InputStream inputStream = new FileInputStream(file);
                if (bl) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                _log.info("Adding input " + file.getName());
                arrayList.add(inputStream);
                continue;
            }
            if (file.isDirectory()) {
                Main.addInputStreams(file, arrayList, bl);
                continue;
            }
            throw new IOException("Not a file or directory: " + string2);
        }
        Object[] objectArray = new InputStream[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private static void addInputStreams(File file, Collection<InputStream> collection, boolean bl) throws IOException {
        for (File file2 : file.listFiles()) {
            if (!file2.isFile()) continue;
            InputStream inputStream = new FileInputStream(file2);
            if (bl) {
                inputStream = new GZIPInputStream(inputStream);
            }
            _log.info("Adding input " + file2.getName());
            collection.add(inputStream);
        }
    }

    public static InputStream getMainInputStream(CommandLine commandLine) throws IOException {
        return Main.getInputStream(commandLine, "i");
    }

    public static InputStream getInputStream(CommandLine commandLine, String string) throws IOException {
        InputStream inputStream = null;
        String string2 = commandLine.getOptionValue(string);
        if (string2 == null || string2.equals("-")) {
            inputStream = System.in;
            _log.info("Input '" + string + "' is stdin");
        } else {
            inputStream = new FileInputStream(string2);
            _log.info("Input '" + string + "' is " + string2);
        }
        if (commandLine.hasOption(string + "gz")) {
            _log.info("Input '" + string + "' is gzipped");
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static int getTicks(CommandLine commandLine) throws IOException {
        if (commandLine.hasOption("ticks")) {
            int n = Integer.parseInt(commandLine.getOptionValue("ticks"));
            _log.info("Ticks set to " + n);
            return n;
        }
        return 0;
    }

    public static OutputStream getOutputStream(CommandLine commandLine, String string) throws IOException {
        OutputStream outputStream = null;
        String string2 = commandLine.getOptionValue(string);
        if (string2 == null || string2.equals("-")) {
            outputStream = System.out;
            _log.info("Output '" + string + "' is stdout");
        } else {
            outputStream = new FileOutputStream(string2);
            _log.info("Output '" + string + "' is " + string2);
        }
        if (commandLine.hasOption(string + "gz")) {
            outputStream = new GZIPOutputStream(outputStream);
            _log.info("Output '" + string + "' is gzipped");
        }
        return outputStream;
    }

    public static OutputStream getMainOutputStream(CommandLine commandLine) throws IOException {
        return Main.getOutputStream(commandLine, "o");
    }

    public static void addOutputOption(Options options, String string, String string2) {
        Option option = new Option(string, (string2 + " output file, - for stdout").trim());
        option.setArgs(1);
        Option option2 = new Option(string + "gz", ("gzip output " + string2).trim());
        option2.setArgs(0);
        options.addOption(option);
        options.addOption(option2);
    }

    public static void addInputOption(Options options, String string, String string2) {
        Option option = new Option(string, (string2 + " input file, - for stdin").trim());
        option.setArgs(1);
        Option option2 = new Option(string + "gz", ("gzipped input " + string2).trim());
        option2.setArgs(0);
        options.addOption(option);
        options.addOption(option2);
    }

    public static void addInputsOption(Options options, String string, String string2) {
        Option option = new Option(string, (string2 + " input files, (all files in all dirs will be considered)").trim());
        option.setArgs(-2);
        Option option2 = new Option(string + "gz", ("*all* gzipped input " + string2).trim());
        option2.setArgs(0);
        options.addOption(option);
        options.addOption(option2);
    }

    public static void addTicksOption(Options options) {
        Option option = new Option("ticks", "ticks for logging, positive int value");
        option.setArgs(1);
        options.addOption(option);
    }

    public static void addHelpOption(Options options) {
        Option option = new Option("h", "help");
        option.setArgs(0);
        options.addOption(option);
    }

    public static Options getStandardOptions() {
        Options options = new Options();
        Main.addInputOption(options, "i", "");
        Main.addOutputOption(options, "o", "");
        Main.addTicksOption(options);
        Main.addHelpOption(options);
        return options;
    }

    public static int[] getMask(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(Character.toString(string.charAt(i)));
        }
        return nArray;
    }

    public static boolean mkdirs(String string) {
        return new File(string).mkdirs();
    }

    public static boolean mkdirsForFile(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            return file2.mkdirs();
        }
        return false;
    }

    static {
        File file = new File(DEFAULT_TMP_DIR);
        if (file.mkdirs()) {
            file.deleteOnExit();
        }
        TMP_DIR = DEFAULT_TMP_DIR;
    }
}

