/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;

public class Head {
    static transient Logger _log = Logger.getLogger(Head.class.getName());

    public static void main(String[] stringArray) throws ParseException, IOException {
        NxParser.DEFAULT_PARSE_DTS = false;
        Options options = Main.getStandardOptions();
        Option option = new Option("p", "percent of data in head; e.g., -h 25");
        option.setArgs(1);
        option.setRequired(true);
        options.addOption(option);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = Main.getMainInputStream(commandLine);
        OutputStream outputStream = Main.getMainOutputStream(commandLine);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        CallbackNxBufferedWriter callbackNxBufferedWriter = new CallbackNxBufferedWriter(bufferedWriter);
        int n = Main.getTicks(commandLine);
        double d = Double.parseDouble(commandLine.getOptionValue("p"));
        if (d > 100.0 || d < 0.0) {
            _log.severe("Head must be greater than 0 and less than 100, not " + d + ".");
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        d /= 100.0;
        NxParser nxParser = new NxParser(inputStream);
        _log.info("Counting triples in input...");
        long l = 0L;
        while (nxParser.hasNext()) {
            nxParser.next();
            if (n <= 0 || ++l % (long)n != 0L) continue;
            _log.info("Counted " + l + " triples in input...");
        }
        _log.info(l + " triples in input...");
        inputStream.close();
        inputStream = Main.getMainInputStream(commandLine);
        nxParser = new NxParser(inputStream);
        long l2 = Math.round((double)l * d);
        _log.info("Writing " + l2 + " triples to output...");
        l = 0L;
        while (nxParser.hasNext() && l < l2) {
            callbackNxBufferedWriter.processStatement((Node[])nxParser.next());
            if (n <= 0 || ++l % (long)n != 0L) continue;
            _log.info("Buffered " + l + " triples to output...");
        }
        _log.info("Buffered " + l + " final triples to output.");
        inputStream.close();
        bufferedWriter.close();
    }
}

