/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.tld.TldManager;
import org.semanticweb.yars.util.CallbackNxBufferedWriter;

public class GetPlds {
    static transient Logger _log = Logger.getLogger(GetPlds.class.getName());
    static TldManager TLDM = null;

    public static void main(String[] stringArray) throws ParseException, IOException {
        Options options = Main.getStandardOptions();
        Option option = new Option("p", "positions to extract PLDs from: e.g. 3 for context 012 for triple (default all)");
        option.setArgs(1);
        option.setRequired(false);
        options.addOption(option);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = Main.getMainInputStream(commandLine);
        OutputStream outputStream = Main.getMainOutputStream(commandLine);
        int n = Main.getTicks(commandLine);
        int[] nArray = null;
        if (commandLine.hasOption("p")) {
            nArray = NodeComparator.NodeComparatorArgs.getIntegerMask(commandLine.getOptionValue("p"));
        }
        NxParser nxParser = new NxParser(inputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        CallbackNxBufferedWriter callbackNxBufferedWriter = new CallbackNxBufferedWriter(bufferedWriter);
        TreeSet<Resource> treeSet = new TreeSet<Resource>();
        int n2 = 0;
        while (nxParser.hasNext()) {
            Node node;
            Node[] nodeArray = (Node[])nxParser.next();
            if (n > 0 && ++n2 % n == 0) {
                _log.info("Read " + n2);
            }
            if (nArray == null) {
                for (Node node2 : nodeArray) {
                    node = GetPlds.extractPld(node2);
                    if (node == null) continue;
                    treeSet.add((Resource)node);
                }
                continue;
            }
            for (int n3 : nArray) {
                node = nodeArray[n3];
                Resource resource = GetPlds.extractPld(node);
                if (resource == null) continue;
                treeSet.add(resource);
            }
        }
        for (Node node : treeSet) {
            callbackNxBufferedWriter.processStatement(new Node[]{node});
        }
        _log.info("Finished. Read " + n2 + ". Found " + treeSet.size() + " PLDs.");
        inputStream.close();
        bufferedWriter.close();
    }

    static int[] getMask(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(Character.toString(string.charAt(i)));
        }
        return nArray;
    }

    static Resource extractPld(Node node) {
        if (!(node instanceof Resource)) {
            return null;
        }
        try {
            URI uRI = new URI(node.toString());
            String string = TLDM.getPLD(uRI);
            if (string != null) {
                string = "http://" + string.toLowerCase() + "/";
                return new Resource(string);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        try {
            TLDM = new TldManager();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

