/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.NxParser;

public class FixBNodes {
    public static void main(String[] stringArray) throws URISyntaxException, IOException {
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        Option option2 = new Option("o", "name of file to write, - for stdout");
        option2.setArgs(1);
        Option option3 = new Option("h", "print help");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        PrintStream printStream = System.out;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        if (commandLine.hasOption("o")) {
            printStream = commandLine.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(commandLine.getOptionValue("o")));
        }
        NxParser nxParser = new NxParser(inputStream, false);
        while (nxParser.hasNext()) {
            Node[] nodeArray = nxParser.next();
            for (int i = 0; i < 4; ++i) {
                if (nodeArray[i] instanceof Resource) {
                    nodeArray[i] = new Resource(NxParser.escapeForNx(nodeArray[i].toString()));
                    continue;
                }
                if (!(nodeArray[i] instanceof BNode)) continue;
                nodeArray[i] = new BNode(nodeArray[i].toString().replace("x", "x78").replace("-", "x"));
            }
            printStream.println(Nodes.toN3(nodeArray));
        }
    }
}

