/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.NxParser;

public class CreateSQL {
    public static void main(String[] stringArray) throws URISyntaxException, IOException {
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        Option option2 = new Option("o", "name of file to write, - for stdout");
        option2.setArgs(1);
        Option option3 = new Option("t", "create tab-delimited file instead of sql input statements");
        option3.setArgs(0);
        Option option4 = new Option("h", "print help");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        options.addOption(option4);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        PrintStream printStream = System.out;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        if (commandLine.hasOption("o")) {
            printStream = commandLine.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(commandLine.getOptionValue("o")));
        }
        boolean bl = false;
        if (commandLine.hasOption("t")) {
            bl = true;
        }
        NxParser nxParser = new NxParser(inputStream, false);
        while (nxParser.hasNext()) {
            Node[] nodeArray = nxParser.next();
            StringBuffer stringBuffer = new StringBuffer();
            if (!bl) {
                stringBuffer.append("INSERT INTO n");
                stringBuffer.append(nodeArray.length);
                stringBuffer.append(" VALUES ('");
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                String string = nodeArray[i].toN3();
                if (string.length() > 2000) {
                    stringBuffer = null;
                    break;
                }
                if (bl) {
                    stringBuffer.append(string.replace("\t", "\\t"));
                } else {
                    stringBuffer.append(string.replace("'", "'"));
                }
                if (i >= nodeArray.length - 1) continue;
                if (bl) {
                    stringBuffer.append("\t");
                    continue;
                }
                stringBuffer.append("','");
            }
            if (stringBuffer == null) continue;
            if (!bl) {
                stringBuffer.append("');");
            }
            printStream.println(stringBuffer);
        }
    }
}

