/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;

public class CreateRDFXML {
    public static void main(String[] stringArray) throws IOException, ParseException {
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        Option option2 = new Option("o", "name of file to write, - for stdout");
        option2.setArgs(1);
        Option option3 = new Option("h", "print help");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        PrintStream printStream = System.out;
        int n = -1;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        if (commandLine.hasOption("o")) {
            printStream = commandLine.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(commandLine.getOptionValue("o")));
        }
        CreateRDFXML.printHeaderRDFXML(printStream);
        Node node = null;
        Node node2 = null;
        ArrayList<Object> arrayList = new ArrayList<Node[]>();
        NxParser nxParser = new NxParser(inputStream);
        while (nxParser.hasNext()) {
            Node[] nodeArray = nxParser.next();
            node2 = nodeArray[0];
            if (node != null && !node2.equals(node)) {
                CreateRDFXML.printRDFXML(arrayList, printStream);
                arrayList = new ArrayList();
            }
            arrayList.add(nodeArray);
            node = node2;
        }
        CreateRDFXML.printRDFXML(arrayList, printStream);
        CreateRDFXML.printFooterRDFXML(printStream);
        inputStream.close();
        printStream.close();
    }

    static void printHeaderRDFXML(PrintStream printStream) {
        printStream.println("<?xml version='1.0'?>");
        printStream.println("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>");
    }

    static void printFooterRDFXML(PrintStream printStream) {
        printStream.println("</rdf:RDF>");
    }

    static void printRDFXML(List<Node[]> list, PrintStream printStream) {
        if (list.isEmpty()) {
            return;
        }
        for (Node[] object : list) {
            if (!object[2].toString().equals("0.0")) continue;
            return;
        }
        Node node = list.get(0)[0];
        printStream.print("<rdf:Description");
        if (node instanceof Resource) {
            printStream.println(" rdf:about='" + CreateRDFXML.escape(node.toString()) + "'>");
        } else if (node instanceof BNode) {
            printStream.println(" rdf:nodeID='" + node.toString() + "'>");
        }
        for (Node[] nodeArray : list) {
            String string = nodeArray[1].toString();
            String string2 = null;
            String string3 = null;
            int n = string.indexOf(35);
            if (n > 0) {
                string2 = string.substring(0, n + 1);
                string3 = string.substring(n + 1, string.length());
            } else {
                n = string.lastIndexOf(47);
                if (n > 0) {
                    string2 = string.substring(0, n + 1);
                    string3 = string.substring(n + 1, string.length());
                }
            }
            if (string2 == null && string3 == null) {
                System.err.println("couldn't separate namespace and localname");
                break;
            }
            printStream.print("\t<" + string3 + " xmlns='" + string2 + "'");
            if (nodeArray[2] instanceof BNode) {
                printStream.println(" rdf:nodeID='" + nodeArray[2].toString() + "'/>");
                continue;
            }
            if (nodeArray[2] instanceof Resource) {
                printStream.println(" rdf:resource='" + CreateRDFXML.escape(nodeArray[2].toString()) + "'/>");
                continue;
            }
            if (!(nodeArray[2] instanceof Literal)) continue;
            Literal literal = (Literal)nodeArray[2];
            if (literal.getLanguageTag() != null) {
                printStream.print(" xml:lang='" + literal.getLanguageTag() + "'");
            } else if (literal.getDatatype() != null) {
                printStream.print(" rdf:datatype='" + literal.getDatatype().toString() + "'");
            }
            printStream.println(">" + CreateRDFXML.escape(nodeArray[2].toString()) + "</" + string3 + ">");
        }
        printStream.println("</rdf:Description>");
    }

    private static String escape(String string) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\"", "&quot;");
        string2 = string2.replaceAll("'", "&apos;");
        return string2;
    }
}

