/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;

public class CreateQuad {
    public static void main(String[] stringArray) throws IOException, ParseException {
        Options options = new Options();
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        options.addOption(option);
        Option option2 = new Option("o", "output directory");
        option2.setArgs(1);
        options.addOption(option2);
        Option option3 = new Option("c", "context");
        option3.setArgs(1);
        options.addOption(option3);
        Option option4 = new Option("h", "print help");
        options.addOption(option4);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        PrintWriter printWriter = new PrintWriter(System.out);
        if (commandLine.hasOption("o")) {
            printWriter = new PrintWriter(new File(commandLine.getOptionValue("c")));
        }
        Resource resource = new Resource(commandLine.getOptionValue("c"));
        NxParser nxParser = new NxParser(inputStream);
        while (nxParser.hasNext()) {
            Node[] nodeArray = nxParser.next();
            printWriter.println(new Nodes(nodeArray[0], nodeArray[1], nodeArray[2], resource).toN3());
        }
        inputStream.close();
        printWriter.close();
    }
}

