/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URISyntaxException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CleanXML {
    public static void main(String[] stringArray) throws URISyntaxException, IOException {
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        Option option2 = new Option("o", "name of file to write, - for stdout");
        option2.setArgs(1);
        Option option3 = new Option("h", "print help");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        PrintStream printStream = System.out;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        if (commandLine.hasOption("o")) {
            printStream = commandLine.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(commandLine.getOptionValue("o")));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            printStream.print(CleanXML.stripNonValidXMLCharacters(string));
        }
    }

    public static String stripNonValidXMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || "".equals(string)) {
            return "";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

