/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.InputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;

public class CheckSorted {
    public static void main(String[] stringArray) throws Exception {
        Options options = new Options();
        Main.addInputOption(options, "i", "sorted input");
        Main.addTicksOption(options);
        Main.addHelpOption(options);
        Option option = new Option("so", "sort order: e.g. 0123 for SPOC 3012 for CSPO (written order preserved)");
        option.setArgs(1);
        option.setRequired(false);
        options.addOption(option);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = Main.getMainInputStream(commandLine);
        int n = Main.getTicks(commandLine);
        NxParser nxParser = new NxParser(inputStream);
        NodeComparator nodeComparator = NodeComparator.NC;
        if (commandLine.hasOption("so")) {
            nodeComparator = new NodeComparator(Main.getMask(commandLine.getOptionValue("so")));
        }
        int n2 = 1;
        boolean bl = true;
        if (nxParser.hasNext()) {
            Node[] nodeArray = (Node[])nxParser.next();
            while (nxParser.hasNext()) {
                Node[] nodeArray2;
                if (n > 0 && ++n2 % n == 0) {
                    System.err.println("Read " + n2);
                }
                if (nodeComparator.compare(nodeArray, nodeArray2 = (Node[])nxParser.next()) > 0) {
                    System.err.println(Nodes.toN3(nodeArray) + " before " + Nodes.toN3(nodeArray2));
                    bl = false;
                }
                nodeArray = nodeArray2;
            }
        }
        System.err.println("Read " + n2);
        if (bl) {
            System.err.println("Passed");
        }
    }
}

