/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Quad;
import org.semanticweb.yars.nx.Resource;

public class Triple
implements Serializable {
    protected Node _pred;
    protected Node _sub;
    protected Node _obj;
    public static final long serialVersionUID = 1L;

    public Triple(Node node, Node node2, Node node3) {
        this._sub = node;
        this._pred = node2;
        this._obj = node3;
    }

    public Triple(Triple triple) {
        this._sub = triple.getSubject();
        this._pred = triple.getPredicate();
        this._obj = triple.getObject();
    }

    public static Triple fromArray(Node[] nodeArray) {
        if (nodeArray.length == 3) {
            return new Triple(nodeArray[0], nodeArray[1], nodeArray[2]);
        }
        if (nodeArray.length == 4) {
            return Quad.fromArray(nodeArray);
        }
        return null;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{this.getSubject(), this.getPredicate(), this.getObject()};
        return nodeArray;
    }

    public Node getObject() {
        return this._obj;
    }

    public Node getPredicate() {
        return this._pred;
    }

    public Node getSubject() {
        return this._sub;
    }

    public void setObject(Node node) {
        this._obj = node;
    }

    public void setPredicate(Resource resource) {
        this._pred = resource;
    }

    public void setSubject(Node node) {
        this._sub = node;
    }

    public String toString() {
        return this.toN3();
    }

    public String toN3() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._sub.toN3());
        stringBuffer.append(" ");
        stringBuffer.append(this._pred.toN3());
        stringBuffer.append(" ");
        stringBuffer.append(this._obj.toN3());
        stringBuffer.append(" .");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = object != null && object instanceof Triple;
        if (bl) {
            Triple triple = (Triple)object;
            bl &= triple._sub.equals(this._sub) && triple._pred.equals(this._pred) && triple._obj.equals(this._obj);
        }
        return bl;
    }

    public int hashCode() {
        return this.toN3().hashCode();
    }
}

