/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.util.NxUtil;

public class Resource
implements Node,
Serializable {
    private static Logger _log = Logger.getLogger(Resource.class.getName());
    protected String _data;
    public static final long serialVersionUID = 1L;

    public Resource() {
        this._data = null;
    }

    public Resource(String string) {
        this(string, false);
    }

    public Resource(URI uRI) {
        this("<" + NxUtil.escapeForNx(uRI.toASCIIString()) + ">", true);
    }

    public Resource(String string, boolean bl) {
        if (!bl) {
            if (string.length() == 0 || string == null) {
                _log.severe("The supplied String for creating a resource was " + (string == null ? "the null pointer" : "the empty string, which MUST NOT be the case in N3"));
                this._data = string == null ? null : "";
                return;
            }
            this._data = string.charAt(0) != '<' ? "<" + string + ">" : string;
        } else {
            this._data = string;
        }
    }

    public String getHost() throws URISyntaxException {
        URI uRI = new URI(this.toN3().substring(1, this.toN3().length() - 1));
        return uRI.getHost();
    }

    @Override
    public int hashCode() {
        return this.toN3().hashCode();
    }

    @Override
    public String toString() {
        return NxUtil.unescape(this.toN3().substring(1, this.toN3().length() - 1));
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    @Override
    public String toN3() {
        return this._data;
    }

    @Override
    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return this.toN3().compareTo(resource.toN3());
        }
        if (object instanceof Literal) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof BNode) {
            return -715827882;
        }
        if (object instanceof Unbound) {
            return -1073741824;
        }
        if (object instanceof Variable) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type Resource but " + object.getClass().getName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return resource.toN3().equals(this.toN3());
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (!this._data.startsWith("<") || !this._data.endsWith(">")) {
            this._data = "<" + this._data + ">";
        }
    }

    public static boolean equals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        int n = string.length();
        if (n == string2.length()) {
            while (--n >= 0) {
                if (string.charAt(n) == string2.charAt(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

