/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.util.TreeSet;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

public class NumericLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    private static final Resource[] INTEGER_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#integer"), new Resource("http://www.w3.org/2001/XMLSchema#int"), new Resource("http://www.w3.org/2001/XMLSchema#positiveInteger"), new Resource("http://www.w3.org/2001/XMLSchema#negativeInteger"), new Resource("http://www.w3.org/2001/XMLSchema#nonPositiveInteger"), new Resource("http://www.w3.org/2001/XMLSchema#nonNegativeInteger"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedInt")};
    private static final Resource[] BYTE_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#byte"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedByte")};
    private static final Resource[] SHORT_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#short"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedShort")};
    private static final Resource[] LONG_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#long"), new Resource("http://www.w3.org/2001/XMLSchema#unsignedLong")};
    private static final Resource[] FLOAT_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#float")};
    private static final Resource[] DOUBLE_TYPES = new Resource[]{new Resource("http://www.w3.org/2001/XMLSchema#double"), new Resource("http://www.w3.org/2001/XMLSchema#decimal")};
    private static final TreeSet<Resource> INTEGERS = NumericLiteral.toTreeSet(new Resource[][]{INTEGER_TYPES});
    private static final TreeSet<Resource> BYTES = NumericLiteral.toTreeSet(new Resource[][]{BYTE_TYPES});
    private static final TreeSet<Resource> SHORTS = NumericLiteral.toTreeSet(new Resource[][]{SHORT_TYPES});
    private static final TreeSet<Resource> LONGS = NumericLiteral.toTreeSet(new Resource[][]{LONG_TYPES});
    private static final TreeSet<Resource> FLOATS = NumericLiteral.toTreeSet(new Resource[][]{FLOAT_TYPES});
    private static final TreeSet<Resource> DOUBLES = NumericLiteral.toTreeSet(new Resource[][]{DOUBLE_TYPES});
    public static final TreeSet<Resource> NUMBERS = NumericLiteral.toTreeSet(INTEGER_TYPES, BYTE_TYPES, SHORT_TYPES, LONG_TYPES, FLOAT_TYPES, DOUBLE_TYPES);
    public static final Resource INTEGER = new Resource("http://www.w3.org/2001/XMLSchema#integer");
    public static final Resource BYTE = new Resource("http://www.w3.org/2001/XMLSchema#byte");
    public static final Resource SHORT = new Resource("http://www.w3.org/2001/XMLSchema#short");
    public static final Resource LONG = new Resource("http://www.w3.org/2001/XMLSchema#long");
    public static final Resource FLOAT = new Resource("http://www.w3.org/2001/XMLSchema#float");
    public static final Resource DOUBLE = new Resource("http://www.w3.org/2001/XMLSchema#double");
    public static final Resource DECIMAL = new Resource("http://www.w3.org/2001/XMLSchema#decimal");
    private Number _n;

    public NumericLiteral(Number number) {
        super(number.toString(), NumericLiteral.getDatatype(number));
        this._n = number;
    }

    public NumericLiteral(Number number, Resource resource) {
        super(number.toString(), resource);
        this._n = number;
    }

    public NumericLiteral(String string, Resource resource, Number number) throws NumberFormatException {
        super(string, resource);
        this._n = number;
    }

    public static NumericLiteral getNumericLiteral(Literal literal) throws ParseException {
        if (literal instanceof NumericLiteral) {
            return (NumericLiteral)literal;
        }
        if (literal instanceof Literal) {
            try {
                Number number = NumericLiteral.parseNumber(literal);
                return new NumericLiteral(literal.getData(), literal.getDatatype(), number);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Cannot parse NumericLiteral from " + literal.toN3());
            }
        }
        throw new ParseException("Cannot parse NumericLiteral from " + literal.getClass().getSimpleName() + " argument.");
    }

    public Number getNumber() {
        return this._n;
    }

    public static Number parseNumber(String string) throws NumberFormatException {
        Number number;
        try {
            number = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            number = Double.parseDouble(string);
        }
        return number;
    }

    public static Resource getDatatype(Number number) {
        if (number instanceof Integer) {
            return INTEGER;
        }
        if (number instanceof Byte) {
            return BYTE;
        }
        if (number instanceof Short) {
            return SHORT;
        }
        if (number instanceof Long) {
            return LONG;
        }
        if (number instanceof Float) {
            return FLOAT;
        }
        return DOUBLE;
    }

    public void stripSign() {
        if (this._n.doubleValue() >= 0.0) {
            return;
        }
        this._n = this._n instanceof Integer ? (Number)(this._n.intValue() * -1) : (Number)(this._n instanceof Byte ? (Number)(Byte.valueOf(this._n.byteValue()) * -1) : (Number)(this._n instanceof Short ? (Number)(Short.valueOf(this._n.shortValue()) * -1) : (Number)(this._n instanceof Long ? (Number)(Long.valueOf(this._n.longValue()) * -1L) : (Number)(this._n instanceof Float ? (Number)Float.valueOf(Float.valueOf(this._n.floatValue()).floatValue() * -1.0f) : (Number)(Double.valueOf(this._n.doubleValue()) * -1.0)))));
        this._data = this._n.toString();
    }

    private static Number parseNumber(Literal literal) throws NumberFormatException {
        if (literal instanceof NumericLiteral) {
            return ((NumericLiteral)literal).getNumber();
        }
        Resource resource = literal.getDatatype();
        if (INTEGERS.contains(resource)) {
            return Integer.parseInt(literal.getData());
        }
        if (DOUBLES.contains(resource)) {
            return Double.parseDouble(literal.getData());
        }
        if (LONGS.contains(resource)) {
            return Long.parseLong(literal.getData());
        }
        if (FLOATS.contains(resource)) {
            return Float.valueOf(Float.parseFloat(literal.getData()));
        }
        if (BYTES.contains(resource)) {
            return Byte.parseByte(literal.getData());
        }
        if (SHORTS.contains(resource)) {
            return Short.parseShort(literal.getData());
        }
        return Double.parseDouble(literal.getData());
    }

    private static TreeSet<Resource> toTreeSet(Resource[] ... resourceArray) {
        TreeSet<Resource> treeSet = new TreeSet<Resource>();
        Resource[][] resourceArray2 = resourceArray;
        int n = resourceArray2.length;
        for (int i = 0; i < n; ++i) {
            Resource[] resourceArray3;
            for (Resource resource : resourceArray3 = resourceArray2[i]) {
                treeSet.add(resource);
            }
        }
        return treeSet;
    }

    public int compareTo(NumericLiteral numericLiteral) {
        double d;
        double d2 = this._n.doubleValue();
        if (d2 == (d = numericLiteral.getNumber().doubleValue())) {
            return 0;
        }
        if (d2 > d) {
            if ((int)(d2 - d) == 0) {
                return 1;
            }
            return (int)(d2 - d);
        }
        if ((int)(d2 - d) == 0) {
            return -1;
        }
        return (int)(d2 - d);
    }
}

