/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.cli.Main;

public class NodeComparator
implements Comparator<Node[]>,
Serializable {
    public static final int NOT_EQUALS_COMP = -2147480429;
    private static Logger _log = Logger.getLogger(NodeComparator.class.getName());
    private static final long serialVersionUID = 1L;
    private boolean _variableLength = true;
    private boolean _nZero = false;
    private boolean _nEquals = false;
    private boolean[] _numeric = null;
    private boolean[] _reverse = null;
    private int[] _order = null;
    private int _n = Integer.MAX_VALUE;
    public static final NodeComparator NC_VAR = new NodeComparator(true);
    public static final NodeComparator NC = new NodeComparator(false);

    public NodeComparator(boolean bl) {
        this._variableLength = bl;
    }

    public NodeComparator(boolean bl, boolean bl2) {
        this._nZero = bl;
        this._nEquals = bl2;
    }

    public NodeComparator(int n) {
        this._n = n;
    }

    public NodeComparator(int[] nArray) {
        this._order = nArray;
    }

    public NodeComparator() {
    }

    public NodeComparator(NodeComparatorArgs nodeComparatorArgs) {
        this._variableLength = nodeComparatorArgs._varLength;
        this._nZero = nodeComparatorArgs._nZero;
        this._nEquals = nodeComparatorArgs._nEquals;
        this._numeric = nodeComparatorArgs._numeric;
        this._reverse = nodeComparatorArgs._reverse;
        this._order = nodeComparatorArgs._order;
        this._n = nodeComparatorArgs._n;
    }

    @Override
    public int compare(Node[] nodeArray, Node[] nodeArray2) {
        int n;
        if (nodeArray == nodeArray2) {
            return 0;
        }
        int n2 = Math.min(Math.min(nodeArray.length, nodeArray2.length), this._n);
        for (n = 0; n < n2; ++n) {
            int n3;
            if (this._order != null) {
                if (this._order.length == n) {
                    if (this._nZero) {
                        return -2147480429;
                    }
                    return 0;
                }
                n3 = this._order[n];
                if (n3 >= nodeArray.length || n3 >= nodeArray2.length) {
                    _log.warning("Cannot compare " + Nodes.toN3(nodeArray) + " with " + Nodes.toN3(nodeArray2) + " for order " + this._order);
                    return Integer.MIN_VALUE;
                }
                int n4 = this.compare(nodeArray[n3], nodeArray2[n3], this._numeric != null && this._numeric.length > n3 && this._numeric[n3], this._reverse != null && this._reverse.length > n3 && this._reverse[n3]);
                if (n4 == 0) continue;
                return n4;
            }
            n3 = nodeArray[n].compareTo(nodeArray2[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (!this._variableLength && (n = nodeArray.length - nodeArray2.length) != 0) {
            return n;
        }
        if (this._nZero) {
            return -2147480429;
        }
        return 0;
    }

    private int compare(Node node, Node node2, boolean bl, boolean bl2) throws NumberFormatException {
        int n;
        if (!bl) {
            n = node.compareTo(node2);
        } else {
            double d = Double.parseDouble(node.toString());
            double d2 = Double.parseDouble(node2.toString());
            n = Double.compare(d, d2);
        }
        if (bl2) {
            n *= -1;
        }
        return n;
    }

    public boolean equals(Node[] nodeArray, Node[] nodeArray2) {
        int n;
        if (nodeArray == nodeArray2) {
            return true;
        }
        if (this._nEquals) {
            return false;
        }
        if (!this._variableLength && (n = nodeArray2.length - nodeArray.length) != 0) {
            return false;
        }
        for (n = 0; n < Math.min(Math.min(nodeArray.length, nodeArray2.length), this._n); ++n) {
            if (this._order != null) {
                if (this._order.length == n) {
                    return true;
                }
                int n2 = this._order[n];
                if (n2 >= nodeArray.length || n2 >= nodeArray2.length) {
                    _log.warning("Cannot compare " + Nodes.toN3(nodeArray) + " with " + Nodes.toN3(nodeArray2) + " for order " + this._order);
                    return false;
                }
                if (nodeArray[n2].equals(nodeArray2[n2])) continue;
                return false;
            }
            if (nodeArray[n].equals(nodeArray2[n])) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        BNode bNode = new BNode("a");
        BNode bNode2 = new BNode("b");
        BNode bNode3 = new BNode("c");
        Node[] nodeArray = new Node[]{bNode};
        Node[] nodeArray2 = new Node[]{bNode, bNode2};
        Node[] nodeArray3 = new Node[]{bNode, bNode2, bNode3};
        Node[] nodeArray4 = new Node[]{bNode3};
        Node[] nodeArray5 = new Node[]{bNode3, bNode3, bNode3};
        TreeSet<Node[]> treeSet = new TreeSet<Node[]>(NC);
        treeSet.add(nodeArray);
        treeSet.add(nodeArray2);
        treeSet.add(nodeArray3);
        treeSet.add(nodeArray4);
        treeSet.add(nodeArray5);
        Iterator<Node[]> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            System.err.println(Nodes.toN3(iterator.next()));
        }
    }

    public static final class NodeComparatorArgs {
        boolean _varLength = false;
        boolean _nZero = false;
        boolean _nEquals = false;
        boolean[] _numeric = null;
        boolean[] _reverse = null;
        int[] _order = null;
        int _n = Integer.MAX_VALUE;

        public void setVarLength(boolean bl) {
            this._varLength = bl;
        }

        public void setNoZero(boolean bl) {
            this._nZero = bl;
        }

        public void setNoEquals(boolean bl) {
            this._nEquals = bl;
        }

        public void setNumeric(boolean[] blArray) {
            this._numeric = blArray;
        }

        public void setReverse(boolean[] blArray) {
            this._reverse = blArray;
        }

        public void setOrder(int[] nArray) {
            this._order = nArray;
        }

        public void setCompareMax(int n) {
            this._n = n;
        }

        public static int[] getIntegerMask(String string) {
            return Main.getMask(string);
        }

        public static boolean[] getBooleanMask(String string) {
            int[] nArray = NodeComparatorArgs.getIntegerMask(string);
            int n = 0;
            for (int n2 : nArray) {
                if (n >= n2) continue;
                n = n2;
            }
            boolean[] blArray = new boolean[n + 1];
            for (int n3 : nArray) {
                blArray[n3] = true;
            }
            return blArray;
        }
    }
}

